/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.BaseButton;

public class Checkbox
extends BaseButton {
    protected ComponentFactory factory;
    protected AstraXButton.AstraXButtonStyle style;
    private Image baseImage;
    private Image knobImage;

    public Checkbox(ComponentFactory componentFactory, String buttonStyle) {
        this.factory = componentFactory;
        this.baseImage = new Image();
        this.addActor(this.baseImage);
        this.knobImage = new Image();
        this.knobImage.setTouchable(Touchable.disabled);
        this.addActor(this.knobImage);
        AstraXButton.AstraXButtonStyle iconStyle = this.factory.getSkin().get(buttonStyle, AstraXButton.AstraXButtonStyle.class).copy();
        this.setStyle(iconStyle);
        this.clickListener = new ClickListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                if (Checkbox.this.style.buttonSounds.soundOver != null && pointer < 0) {
                    Checkbox.this.factory.playUISound(Checkbox.this.style.buttonSounds.soundOver);
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Checkbox.this.isDisabled() && !Checkbox.this.canCheck()) {
                    return;
                }
                Checkbox.this.setChecked(!Checkbox.this.isChecked(), true);
            }
        };
        this.addListener(this.clickListener);
    }

    public void setStyle(AstraXButton.AstraXButtonStyle style) {
        this.style = style;
        this.baseImage.setDrawable(this.style.baseDrawable);
        this.baseImage.setSize(this.style.width, this.style.height);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        this.baseImage.setAlign(1);
        this.baseImage.setOrigin(this.baseImage.getWidth() / 2.0f, this.baseImage.getHeight() / 2.0f);
        this.setInlineIcon(style.iconDrawable);
        this.setSize(this.style.width, this.style.height);
    }

    private void setInlineIcon(Drawable iconImage) {
        this.style.iconDrawable = iconImage;
        this.knobImage.setVisible(true);
        this.knobImage.setDrawable(this.style.iconDrawable);
        this.knobImage.setSize(this.knobImage.getDrawable().getMinWidth() - (float)(this.style.padding * 2), this.knobImage.getDrawable().getMinHeight() - (float)(this.style.padding * 2));
        this.knobImage.setColor(this.style.iconColor.getColor(this));
        this.knobImage.setAlign(1);
        this.knobImage.setOrigin(1);
        this.knobImage.setPosition((float)this.style.width / 2.0f - (float)(this.style.width - this.style.padding * 2) / 2.0f, (float)this.style.height / 2.0f - (float)(this.style.height - this.style.padding * 2) / 2.0f);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.knobImage.setPosition(width / 2.0f - (float)(this.style.width - this.style.padding * 2) / 2.0f, height / 2.0f - (float)(this.style.height - this.style.padding * 2) / 2.0f);
    }

    @Override
    public float getPrefWidth() {
        return this.style.width;
    }

    @Override
    public float getPrefHeight() {
        return this.style.height;
    }

    @Override
    public void setChecked(boolean isChecked, boolean fireEvent) {
        if (fireEvent) {
            if (isChecked) {
                if (this.style.buttonSounds.soundPressed != null) {
                    this.factory.playUISound(this.style.buttonSounds.soundPressed);
                }
                this.knobImage.addAction(Actions.moveTo(this.baseImage.getWidth() - this.knobImage.getWidth() - (float)this.style.padding, this.knobImage.getY(), 0.07f));
            } else {
                if (this.style.buttonSounds.soundRelease != null) {
                    this.factory.playUISound(this.style.buttonSounds.soundRelease);
                }
                this.knobImage.addAction(Actions.moveTo(this.style.padding, this.knobImage.getY(), 0.2f));
            }
        } else if (isChecked) {
            this.knobImage.addAction(Actions.moveTo(this.baseImage.getWidth() - this.knobImage.getWidth() - (float)this.style.padding, this.knobImage.getY()));
        } else {
            this.knobImage.addAction(Actions.moveTo(this.style.padding, this.knobImage.getY()));
        }
        super.setChecked(isChecked, fireEvent);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        this.knobImage.setColor(this.style.iconColor.getColor(this));
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        this.baseImage.setUserObject(userObject);
    }
}

