/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.sfx.ButtonSounds;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.util.animation.Tweening;

public class CompositeButton
extends SimplePanel
implements Button {
    protected ClickListener clickListener;
    protected ButtonGroup buttonGroup;
    protected boolean isChecked;
    protected boolean isDisabled;
    protected boolean canCheck = true;
    protected boolean programmaticChangeEvents;
    private boolean squishable = false;
    protected CustomAction buttonAction;

    public CompositeButton(ComponentFactory factory, CompositeButtonStyle style, String backgroundStyle) {
        super(factory, style, backgroundStyle);
    }

    public CompositeButton(ComponentFactory factory, String buttonStyle, String backgroundStyle) {
        this(factory, factory.getSkin().get(buttonStyle, CompositeButtonStyle.class), backgroundStyle);
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!event.getBubbles()) {
                    return false;
                }
                if (CompositeButton.this.getCompositeStyle().buttonSounds.soundPressed != null) {
                    CompositeButton.this.componentFactory.playUISound(CompositeButton.this.getCompositeStyle().buttonSounds.soundPressed);
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (CompositeButton.this.getCompositeStyle().buttonSounds.soundRelease != null) {
                    CompositeButton.this.componentFactory.playUISound(CompositeButton.this.getCompositeStyle().buttonSounds.soundRelease);
                }
                super.touchUp(event, x, y, pointer, button);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (CompositeButton.this.isDisabled() || !event.getBubbles()) {
                    return;
                }
                super.enter(event, x, y, pointer, fromActor);
                if (CompositeButton.this.getCompositeStyle().buttonSounds.soundOver != null && pointer < 0) {
                    CompositeButton.this.componentFactory.playUISound(CompositeButton.this.getCompositeStyle().buttonSounds.soundOver);
                }
                if (CompositeButton.this.isSquishable()) {
                    CompositeButton.this.background.addAction(Tweening.getSquish(0.1f, null));
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!event.getBubbles()) {
                    return;
                }
                if (CompositeButton.this.isDisabled() && !CompositeButton.this.canCheck()) {
                    return;
                }
                if (!CompositeButton.this.isChecked()) {
                    CompositeButton.this.background.addAction(Tweening.getSquish(0.03f, CompositeButton.this.buttonAction));
                } else {
                    CompositeButton.this.background.addAction(Tweening.getSquish(0.01f, CompositeButton.this.buttonAction));
                }
                CompositeButton.this.setChecked(!CompositeButton.this.isChecked(), true);
            }
        };
        this.addListener(this.clickListener);
    }

    public CompositeButton(ComponentFactory factory) {
        this(factory, "default", "outset-button");
    }

    protected CompositeButtonStyle getCompositeStyle() {
        return (CompositeButtonStyle)this.panelStyle;
    }

    public boolean isSquishable() {
        return this.squishable;
    }

    public void setSquishable(boolean squishable) {
        this.squishable = squishable;
    }

    public void centerBackground() {
        this.background.setSize(this.getWidth(), this.getHeight());
        this.background.setAlign(1);
        this.background.setOrigin(this.background.getWidth() / 2.0f, this.background.getHeight() / 2.0f);
    }

    protected void setChecked(boolean isChecked, boolean fireEvent) {
        if (!this.canCheck) {
            return;
        }
        if (this.isChecked == isChecked) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
        if (fireEvent) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.isChecked = !isChecked;
            }
            Pools.free(changeEvent);
        }
    }

    public void setButtonAction(CustomAction buttonAction) {
        this.buttonAction = buttonAction;
    }

    @Override
    public boolean isChecked() {
        return this.isChecked;
    }

    @Override
    public boolean isPressed() {
        if (this.clickListener == null) {
            return false;
        }
        return this.clickListener.isVisualPressed();
    }

    @Override
    public boolean isOver() {
        if (this.clickListener == null) {
            return false;
        }
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    @Override
    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
    }

    @Override
    public void setChecked(boolean isChecked) {
        this.setChecked(isChecked, this.programmaticChangeEvents);
    }

    @Override
    public boolean canCheck() {
        return this.canCheck;
    }

    @Override
    public void setCanCheck(boolean canCheck) {
        this.canCheck = canCheck;
    }

    @Override
    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.background.setColor(this.background.getStyle().color.getColor(this));
        super.draw(batch, parentAlpha);
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        this.background.setUserObject(userObject);
    }

    public static class CompositeButtonStyle
    extends AbstractPanel.AbstractPanelStyle {
        public ButtonSounds buttonSounds;
    }
}

