/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.ui.commons.buttons.Button;

public class ReactiveColor {
    public Color upColor;
    public Color downColor;
    public Color overColor;
    public Color checkedColor;
    public Color checkedOverColor;
    public Color checkedDownColor;
    public Color disabledColor;
    public Color focusedColor;
    public Color focusedCheckedColor;

    public ReactiveColor copy() {
        ReactiveColor copy = new ReactiveColor();
        copy.upColor = this.upColor.cpy();
        copy.downColor = this.downColor.cpy();
        copy.overColor = this.overColor.cpy();
        if (this.checkedColor != null) {
            copy.checkedColor = this.checkedColor.cpy();
        }
        if (this.checkedOverColor != null) {
            copy.checkedOverColor = this.checkedOverColor.cpy();
        }
        if (this.checkedDownColor != null) {
            copy.checkedDownColor = this.checkedDownColor.cpy();
        }
        if (this.disabledColor != null) {
            copy.disabledColor = this.disabledColor.cpy();
        }
        if (this.focusedColor != null) {
            copy.focusedColor = this.focusedColor.cpy();
        }
        if (this.focusedCheckedColor != null) {
            copy.focusedCheckedColor = this.focusedCheckedColor.cpy();
        }
        return copy;
    }

    public Color getColor(Button button) {
        if (button.isDisabled() && this.disabledColor != null) {
            return this.disabledColor;
        }
        if (button.isPressed()) {
            if (button.isChecked() && this.checkedDownColor != null && button.canCheck()) {
                return this.checkedDownColor;
            }
            if (this.downColor != null) {
                return this.downColor;
            }
        }
        if (button.isOver()) {
            if (button.isChecked() && button.canCheck()) {
                if (this.checkedOverColor != null) {
                    return this.checkedOverColor;
                }
            } else if (this.overColor != null) {
                return this.overColor;
            }
        }
        boolean focused = button.hasKeyboardFocus();
        if (button.isChecked() && button.canCheck()) {
            if (focused && this.focusedCheckedColor != null) {
                return this.focusedCheckedColor;
            }
            if (this.checkedColor != null) {
                return this.checkedColor;
            }
            if (button.isOver() && this.overColor != null) {
                return this.overColor;
            }
        }
        if (focused && this.focusedColor != null) {
            return this.focusedColor;
        }
        return this.upColor;
    }

    public Color getColor(ReactiveState reactiveState) {
        switch (reactiveState) {
            case DOWN: {
                if (this.downColor != null) {
                    return this.downColor;
                }
            }
            case CHECKED: {
                if (this.checkedColor != null) {
                    return this.checkedColor;
                }
            }
            case CHECKED_DOWN: {
                if (this.checkedDownColor != null) {
                    return this.checkedDownColor;
                }
            }
            case CHECKED_OVER: {
                if (this.checkedOverColor != null) {
                    return this.checkedOverColor;
                }
            }
            case OVER: {
                if (this.overColor != null) {
                    return this.overColor;
                }
            }
            case DISABLED: {
                if (this.disabledColor != null) {
                    return this.disabledColor;
                }
            }
            case FOCUSED: {
                if (this.focusedColor != null) {
                    return this.focusedColor;
                }
            }
            case FOCUSED_CHECKED: {
                if (this.focusedCheckedColor == null) break;
                return this.focusedCheckedColor;
            }
        }
        return this.upColor;
    }

    public static enum ReactiveState {
        UP,
        DOWN,
        OVER,
        CHECKED,
        CHECKED_OVER,
        CHECKED_DOWN,
        DISABLED,
        FOCUSED,
        FOCUSED_CHECKED;

    }
}

