/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class StaticIcon
extends Group {
    private Skin skin;
    private StaticIconStyle style;
    private Image baseImage;
    private Image iconImage;

    public StaticIcon(Skin skin, String baseStyle) {
        this.skin = skin;
        this.baseImage = new Image();
        this.addActor(this.baseImage);
        this.iconImage = new Image();
        this.addActor(this.iconImage);
        this.setStyle(skin.get(baseStyle, StaticIconStyle.class));
    }

    public StaticIcon(StaticIconStyle style) {
        this.baseImage = new Image();
        this.addActor(this.baseImage);
        this.iconImage = new Image();
        this.addActor(this.iconImage);
        this.setStyle(style);
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public StaticIconStyle getStyle() {
        return this.style;
    }

    public void setInlineIcon(String drawable) {
        this.setInlineIcon(this.skin.getDrawable(drawable));
    }

    public void setInlineIcon(Drawable iconImage) {
        this.style.icon = iconImage;
        if (this.style.icon != null) {
            this.iconImage.setVisible(true);
            this.iconImage.setDrawable(this.style.icon);
            this.iconImage.setSize(this.style.width - this.style.padding * 2, this.style.height - this.style.padding * 2);
            this.iconImage.setColor(this.style.iconColor);
            this.iconImage.setAlign(1);
            this.iconImage.setOrigin(1);
            this.iconImage.layout();
            this.iconImage.setPosition((float)this.style.width / 2.0f - (float)(this.style.width - this.style.padding * 2) / 2.0f, (float)this.style.height / 2.0f - (float)(this.style.height - this.style.padding * 2) / 2.0f);
        } else {
            this.iconImage.setVisible(false);
        }
    }

    public void setStyle(StaticIconStyle style) {
        this.style = style;
        if (this.style.base != null) {
            this.baseImage.setVisible(true);
            this.baseImage.setDrawable(this.style.base);
            this.baseImage.setSize(this.style.width, this.style.height);
            this.baseImage.setColor(this.style.baseColor);
            this.baseImage.setAlign(1);
            this.baseImage.layout();
            this.baseImage.setOrigin(this.baseImage.getWidth() / 2.0f, this.baseImage.getHeight() / 2.0f);
        } else {
            this.baseImage.setVisible(false);
        }
        this.setInlineIcon(this.style.icon);
        this.setSize(this.style.width, this.style.height);
    }

    public static class StaticIconStyle {
        public int width = 32;
        public int height = 32;
        public int padding = 10;
        private Drawable base;
        private Color baseColor;
        private Drawable icon;
        private Color iconColor;
    }
}

