/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractForm
extends AbstractPanel
implements Form {
    public List<AstraXLabel> labelColumn = new ArrayList<AstraXLabel>();
    public List<Actor> valueColumn = new ArrayList<Actor>();

    public AbstractForm(ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory, style, backgroundStyle);
    }

    @Deprecated
    public AbstractForm(ComponentFactory componentFactory, String style) {
        super(componentFactory, style);
    }

    @Deprecated
    public AbstractForm(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.labelColumn.clear();
        this.valueColumn.clear();
    }

    @Override
    public void addRow(String labelText, Actor valueWidget, int valueColspan) {
        AstraXLabel label = this.addLabel(labelText);
        this.addValue(valueWidget, valueColspan);
        this.labelColumn.add(label);
        this.valueColumn.add(valueWidget);
    }

    public void markLabels(ValidationResult validationResult) {
        this.resetStyles();
        for (ValidationResult.ValidationMessage message : validationResult.getMessages()) {
            int componentIndex;
            if (message.component == null || (componentIndex = this.valueColumn.indexOf(message.component)) < 0) continue;
            AstraXLabel labelForComponent = this.labelColumn.get(componentIndex);
            labelForComponent.getBackground().setState(ReactiveColor.ReactiveState.CHECKED);
        }
    }

    @Override
    public void resetStyles() {
        for (AstraXLabel label : this.labelColumn) {
            label.setStyle(this.panelStyle.labelStyle);
            label.getBackground().setState(ReactiveColor.ReactiveState.UP);
        }
    }
}

