/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ButtonClickListener;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class FormContainer<F extends AbstractForm>
extends Table {
    private boolean resettable = false;
    private FormContainerStyle formContainerStyle;
    private F form;
    private TextButton submitButton;
    private TextButton resetButton;
    private TextButton cancelButton;
    private Table buttonGroup;
    private Label messageLabel;
    private ValidationResult validationResult;
    private List<DefaultFormListener> listeners = new ArrayList<DefaultFormListener>();

    public FormContainer(ComponentFactory factory, F controlledForm) {
        super(factory.getSkin());
        Skin skin = factory.getSkin();
        this.formContainerStyle = skin.get(FormContainerStyle.class);
        this.form = controlledForm;
        this.messageLabel = new Label((CharSequence)"", this.formContainerStyle.untouchedLabel);
        this.buttonGroup = new Table(skin);
        this.cancelButton = new TextButton("Cancel", this.formContainerStyle.cancelButtonStyle);
        this.cancelButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.cancelButton.addListener(factory.getButtonSoundListener(this.formContainerStyle.cancelButtonSoundsID));
        this.cancelButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    for (DefaultFormListener defaultFormListener : FormContainer.this.listeners) {
                        defaultFormListener.onFormCancel(FormContainer.this.form);
                    }
                    event.stop();
                }
            }
        });
        this.resetButton = new TextButton("Reset", this.formContainerStyle.resetButtonStyle);
        this.resetButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.resetButton.addListener(factory.getButtonSoundListener(this.formContainerStyle.resetButtonSoundsID));
        this.resetButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    FormContainer.this.resetForm();
                    for (DefaultFormListener defaultFormListener : FormContainer.this.listeners) {
                        defaultFormListener.onFormReset(FormContainer.this.form);
                    }
                    event.stop();
                }
            }
        });
        this.submitButton = new TextButton("OK", this.formContainerStyle.submitButtonStyle);
        this.submitButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.submitButton.addListener(factory.getButtonSoundListener(this.formContainerStyle.submitButtonSoundsID));
        this.submitButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    FormContainer.this.validateForm();
                    event.stop();
                }
            }
        });
    }

    private void validateForm() {
        ((AbstractForm)this.form).resetStyles();
        this.validationResult = this.form.validateForm(null);
        this.showValidationResults(this.validationResult);
        for (DefaultFormListener defaultFormListener : this.listeners) {
            defaultFormListener.onFormSubmit((AbstractForm)this.form);
        }
    }

    public void setButtonTexts(String cancelButtonText, String resetButtonText, String submitButtonText) {
        this.cancelButton.setText(cancelButtonText);
        this.resetButton.setText(resetButtonText);
        this.submitButton.setText(submitButtonText);
    }

    public void setButtonClickListeners(ButtonClickListener submit, ButtonClickListener cancel, ButtonClickListener reset) {
        this.submitButton.addListener(submit);
        this.cancelButton.addListener(cancel);
        if (this.resettable) {
            this.resetButton.addListener(reset);
        }
    }

    public boolean isResettable() {
        return this.resettable;
    }

    public void setResettable(boolean resettable) {
        this.resettable = resettable;
    }

    public void resetForm() {
        this.messageLabel.setText("");
        this.messageLabel.setStyle(this.formContainerStyle.untouchedLabel);
        ((AbstractForm)this.form).resetStyles();
        this.form.resetForm();
    }

    public F getForm() {
        return this.form;
    }

    public void construct() {
        this.clear();
        this.buttonGroup.add(this.cancelButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f).fill();
        if (this.resettable) {
            this.buttonGroup.add(this.resetButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f);
        } else {
            this.buttonGroup.add().fill().pad(2.0f);
        }
        this.buttonGroup.add(this.submitButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f).fill();
        this.buttonGroup.pack();
        this.add(this.form).fill();
        this.row();
        this.add(this.messageLabel).minHeight(50.0f).padLeft(10.0f).padRight(10.0f).fillX();
        this.row();
        this.add(this.buttonGroup).fill();
        this.pack();
    }

    public void addFormListener(DefaultFormListener defaultFormListener) {
        if (defaultFormListener == null) {
            return;
        }
        if (this.listeners.contains(defaultFormListener)) {
            return;
        }
        if (this.cancelButton == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Component must be initialized first.");
        }
        this.listeners.add(defaultFormListener);
    }

    public void removeFormListener(DefaultFormListener defaultFormListener) {
        if (defaultFormListener == null) {
            return;
        }
        this.listeners.add(defaultFormListener);
    }

    public void showValidationResults(ValidationResult validationResult) {
        this.validationResult = validationResult;
        switch (validationResult.getStatus()) {
            case VALID: {
                this.messageLabel.setStyle(this.formContainerStyle.submitLabel);
                break;
            }
            case INVALID: {
                this.messageLabel.setStyle(this.formContainerStyle.errorLabel);
                break;
            }
            case UNTOUCHED: {
                this.messageLabel.setStyle(this.formContainerStyle.warningLabel);
            }
        }
        String messages = "";
        for (ValidationResult.ValidationMessage message : validationResult.getMessages()) {
            String string = messages = messages.isEmpty() ? "- " + message.message : messages + "\n- " + message.message;
            if (message.component == null) continue;
        }
        this.messageLabel.setText(messages);
    }

    public static class FormContainerStyle {
        public String cancelButtonSoundsID;
        public TextButton.TextButtonStyle cancelButtonStyle;
        public String resetButtonSoundsID;
        public TextButton.TextButtonStyle resetButtonStyle;
        public String submitButtonSoundsID;
        public TextButton.TextButtonStyle submitButtonStyle;
        public int minButtonWidth = 20;
        public int minButtonHeight = 10;
        public int buttonInnerPadding = 7;
        public Label.LabelStyle errorLabel;
        public Label.LabelStyle warningLabel;
        public Label.LabelStyle submitLabel;
        public Label.LabelStyle untouchedLabel;
    }
}

