/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.FormControllerBase;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;

public class FormController<F extends AbstractForm>
extends FormControllerBase {
    private F form;

    public FormController(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public void setForm(F form) {
        this.form = form;
    }

    @Override
    public AbstractForm getActiveForm() {
        return this.form;
    }

    @Override
    public void resetForm() {
        ((AbstractForm)this.form).resetStyles();
        ((AbstractPanel)this.form).resetValues();
        this.validationResult = null;
    }

    @Override
    public void validateForm() {
        this.validationResult = new ValidationResult();
        this.form.validateForm(this.validationResult);
        this.showValidationResults(this.validationResult);
        if (this.validationResult.getStatus() == Form.ValidationStatus.VALID) {
            this.notifyOnSubmit(this.getActiveForm());
        }
    }

    @Override
    public void showValidationResults(ValidationResult validationResult) {
        AstraXApp.astraX.showValidationMessages(validationResult);
        ((AbstractForm)this.form).markLabels(validationResult);
    }
}

