/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.FormListener;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FormControllerBase {
    protected ComponentFactory componentFactory;
    protected AstraXTextButton submitButton;
    protected AstraXTextButton backButton;
    protected AstraXTextButton resetButton;
    protected Map<String, AstraXTextButton> customButtons = new LinkedHashMap<String, AstraXTextButton>();
    protected ValidationResult validationResult;
    protected List<FormListener> listeners = new ArrayList<FormListener>();

    public FormControllerBase(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public AstraXTextButton addSubmitButton(String text, String soundID) {
        this.submitButton = this.componentFactory.getTextButton("primary", text, soundID);
        this.submitButton.setCanCheck(false);
        this.submitButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                FormControllerBase.this.validateForm();
            }
        });
        return this.submitButton;
    }

    public AstraXTextButton addSubmitButton(String text) {
        return this.addSubmitButton(text, "submit");
    }

    public AstraXTextButton addResetButton(String text) {
        this.resetButton = this.componentFactory.getTextButton("secondary", text, "submit");
        this.resetButton.setCanCheck(false);
        this.resetButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                FormControllerBase.this.notifyOnReset(FormControllerBase.this.getActiveForm());
            }
        });
        return this.resetButton;
    }

    public AstraXTextButton addBackButton(String text) {
        this.backButton = this.componentFactory.getTextButton("secondary", text, "submit");
        this.backButton.setCanCheck(false);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                FormControllerBase.this.notifyOnCancel(FormControllerBase.this.getActiveForm());
            }
        });
        return this.backButton;
    }

    public AstraXTextButton addCustomButton(String text, String style, final String action) {
        AstraXTextButton customButton = this.componentFactory.getTextButton(style, text, null);
        customButton.setCanCheck(false);
        customButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                FormControllerBase.this.notifyOnFormAction(FormControllerBase.this.getActiveForm(), action);
            }
        });
        this.customButtons.put(action, customButton);
        return customButton;
    }

    public AstraXTextButton getSubmitButton() {
        return this.submitButton;
    }

    public AstraXTextButton getBackButton() {
        return this.backButton;
    }

    public AstraXTextButton getResetButton() {
        return this.resetButton;
    }

    public void addListener(FormListener defaultFormListener) {
        if (defaultFormListener == null) {
            return;
        }
        this.listeners.add(defaultFormListener);
    }

    protected void notifyOnCancel(AbstractForm form) {
        for (FormListener defaultFormListener : this.listeners) {
            defaultFormListener.onFormCancel(form);
        }
    }

    protected void notifyOnReset(AbstractForm form) {
        for (FormListener defaultFormListener : this.listeners) {
            defaultFormListener.onFormReset(form);
        }
    }

    protected void notifyOnSubmit(AbstractForm form) {
        for (FormListener defaultFormListener : this.listeners) {
            defaultFormListener.onFormSubmit(form);
        }
    }

    protected void notifyOnFormAction(AbstractForm form, String action) {
        for (FormListener defaultFormListener : this.listeners) {
            defaultFormListener.onFormAction(form, action);
        }
    }

    public abstract AbstractForm getActiveForm();

    public abstract void resetForm();

    public abstract void validateForm();

    public abstract void showValidationResults(ValidationResult var1);
}

