/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.FormController;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class GenericFormContainer<F extends AbstractForm>
extends SimplePanel {
    protected FormController<F> formController;
    protected F form;

    public static <T extends AbstractForm> GenericFormContainer<T> createFormContainer(ComponentFactory componentFactory, T form, String cancelTranslationID, String resetTranslationID, String submitTranslationID) {
        GenericFormContainer<T> formContainer = new GenericFormContainer<T>(componentFactory, form);
        int colspan = 0;
        if (cancelTranslationID != null) {
            ++colspan;
        }
        if (resetTranslationID != null) {
            ++colspan;
        }
        if (submitTranslationID != null) {
            ++colspan;
        }
        formContainer.addValue((Actor)formContainer.form).colspan(colspan);
        formContainer.row();
        if (cancelTranslationID != null) {
            AstraXTextButton cancelButton = formContainer.formController.addBackButton(componentFactory.translate(cancelTranslationID));
            cancelButton.setSquishable(false);
            formContainer.addValueCentered(cancelButton).minWidth(120.0f);
        }
        if (resetTranslationID != null) {
            AstraXTextButton resetButton = formContainer.formController.addResetButton(componentFactory.translate(resetTranslationID));
            resetButton.setSquishable(false);
            formContainer.addValueCentered(resetButton).minWidth(120.0f);
        }
        if (submitTranslationID != null) {
            AstraXTextButton submitButton = formContainer.formController.addSubmitButton(componentFactory.translate(submitTranslationID));
            submitButton.setSquishable(false);
            formContainer.addValueCentered(submitButton).minWidth(120.0f);
        }
        formContainer.pack();
        return formContainer;
    }

    protected GenericFormContainer(ComponentFactory componentFactory, F form) {
        super(componentFactory);
        this.form = form;
        this.formController = new FormController(componentFactory);
        this.formController.setForm(this.form);
    }

    public FormController<F> getFormController() {
        return this.formController;
    }

    public F getForm() {
        return this.form;
    }
}

