/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.MultiFormController;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import java.util.List;

public class GenericMultiFormContainer
extends SimplePanel {
    public MultiFormController multiFormController;
    public FlexTab tabController;

    public GenericMultiFormContainer(ComponentFactory componentFactory) {
        super(componentFactory);
        this.multiFormController = new MultiFormController(componentFactory);
        this.tabController = new FlexTab(componentFactory, "default");
    }

    public static GenericMultiFormContainer createFormContainer(ComponentFactory componentFactory, List<AbstractForm> forms, boolean vertical, String cancelTranslationID, String resetTranslationID, String submitTranslationID) {
        WidgetGroup tabButtons;
        GenericMultiFormContainer formContainer = new GenericMultiFormContainer(componentFactory);
        int colspan = 0;
        if (cancelTranslationID != null) {
            ++colspan;
        }
        if (resetTranslationID != null) {
            ++colspan;
        }
        if (submitTranslationID != null) {
            ++colspan;
        }
        if (vertical) {
            tabButtons = new VerticalGroup();
            ((VerticalGroup)tabButtons).space(10.0f);
            ((VerticalGroup)tabButtons).top();
            for (AbstractForm form : forms) {
                formContainer.getFormController().putForm(form);
                AstraXTextButton tabButton = formContainer.tabController.addTabWithTextButton(form.getName(), "secondary-tab", form);
                tabButtons.addActor(tabButton);
            }
            formContainer.add(tabButtons).padRight(10.0f).top();
        } else {
            tabButtons = new HorizontalGroup();
            ((HorizontalGroup)tabButtons).space(10.0f);
            ((HorizontalGroup)tabButtons).top();
            for (AbstractForm form : forms) {
                formContainer.getFormController().putForm(form);
                AstraXTextButton tabButton = formContainer.tabController.addTabWithTextButton(form.getName(), "secondary-tab", form);
                tabButtons.addActor(tabButton);
            }
            formContainer.add(tabButtons).padBottom(10.0f).colspan(colspan).top();
            formContainer.row();
        }
        formContainer.addValue(formContainer.tabController.getContentStack()).colspan(colspan).top();
        formContainer.row();
        SimplePanel formButtons = new SimplePanel(componentFactory);
        formButtons.align(1);
        if (cancelTranslationID != null) {
            AstraXTextButton cancelButton = formContainer.multiFormController.addBackButton(componentFactory.translate(cancelTranslationID));
            cancelButton.setSquishable(false);
            formButtons.addValue(cancelButton);
        }
        if (resetTranslationID != null) {
            AstraXTextButton resetButton = formContainer.multiFormController.addResetButton(componentFactory.translate(resetTranslationID));
            resetButton.setSquishable(false);
            formButtons.addValue(resetButton);
        }
        if (submitTranslationID != null) {
            AstraXTextButton submitButton = formContainer.multiFormController.addSubmitButton(componentFactory.translate(submitTranslationID));
            submitButton.setSquishable(false);
            formButtons.addValue(submitButton);
        }
        formButtons.pack();
        formContainer.add(formButtons).colspan(colspan).padTop(10.0f).center().maxWidth(ComponentFactory.GAME_MENU_WIDTH);
        formContainer.pack();
        return formContainer;
    }

    public List<Button> getTabButtons() {
        return this.tabController.getTabButtons();
    }

    public MultiFormController getFormController() {
        return this.multiFormController;
    }
}

