/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.FormControllerBase;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiFormController
extends FormControllerBase {
    protected Map<Class, AbstractForm> forms = new LinkedHashMap<Class, AbstractForm>();

    public MultiFormController(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public void putForm(AbstractForm form) {
        this.forms.put(form.getClass(), form);
    }

    public <T extends AbstractForm> T getForm(Class<T> clazz) {
        return (T)this.forms.get(clazz);
    }

    public Collection<AbstractForm> getForms() {
        return this.forms.values();
    }

    @Override
    public AbstractForm getActiveForm() {
        AbstractForm visibleForm = null;
        for (AbstractForm form : this.forms.values()) {
            if (!form.isVisible()) continue;
            visibleForm = form;
        }
        return visibleForm;
    }

    @Override
    public void resetForm() {
        for (AbstractForm form : this.forms.values()) {
            form.resetStyles();
            form.resetValues();
        }
        this.validationResult = null;
    }

    @Override
    public void validateForm() {
        this.validationResult = new ValidationResult();
        AbstractForm visibleForm = null;
        for (AbstractForm form : this.forms.values()) {
            form.validateForm(this.validationResult);
            if (!form.isVisible()) continue;
            visibleForm = form;
        }
        this.showValidationResults(this.validationResult);
        if (this.validationResult.getStatus() == Form.ValidationStatus.VALID) {
            this.notifyOnSubmit(visibleForm);
        }
    }

    @Override
    public void showValidationResults(ValidationResult validationResult) {
        if (validationResult.getStatus() == Form.ValidationStatus.VALID) {
            validationResult.addMessage(this.componentFactory.translate("form_validation_message_applied_changes"));
        }
        AstraXApp.astraX.showValidationMessages(validationResult);
        for (AbstractForm form : this.forms.values()) {
            form.markLabels(validationResult);
        }
    }
}

