/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.tab.Tab;
import com.neutronio.astrax.ui.main.newgame.NewGameTab;
import java.util.ArrayList;
import java.util.List;

public abstract class TabbedForm<OUTPUT>
extends Tab {
    private String successMessage = null;
    private ValidationMode validationMode = ValidationMode.ALL;
    private Form.ValidationStatus validationStatus = Form.ValidationStatus.UNTOUCHED;
    private IconLabel messageLabel;
    private AstraXTextButton startButton;
    private AstraXTextButton backButton;
    private List<AbstractForm> forms = new ArrayList<AbstractForm>();
    private List<NewGameTab.GroupFormListener> listeners = new ArrayList<NewGameTab.GroupFormListener>();

    public TabbedForm(ComponentFactory factory, String style, String backgroundStyle) {
        super(factory, style, backgroundStyle);
        this.startButton = new AstraXTextButton(this.componentFactory, "primary");
        this.startButton.setText(this.componentFactory.translate("form_start"));
        this.startButton.setCanCheck(false);
        this.startButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                TabbedForm.this.validateForms();
                event.stop();
            }
        });
        this.backButton = new AstraXTextButton(this.componentFactory, "secondary");
        this.backButton.setText(this.componentFactory.translate("form_back"));
        this.backButton.setCanCheck(false);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    TabbedForm.this.notifyOnBack();
                    event.stop();
                }
            }
        });
        this.messageLabel = new IconLabel(this.componentFactory, "empty");
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    @Override
    public void addTab(String title, Group content) {
        super.addTab(title, content);
        this.logger.warning(String.format("Warning: you are using TabbedForm.addTab to add a '%s' (Tab: '%s'). This component will not be affected by form validation. Are you sure you wanted to do that?", content.getClass().getCanonicalName(), title));
    }

    public void setBackButtonVisible(boolean visible) {
        this.backButton.setVisible(visible);
    }

    public AstraXTextButton getStartButton() {
        return this.startButton;
    }

    public AstraXTextButton getBackButton() {
        return this.backButton;
    }

    public void setButtonTexts(String backText, String submitText) {
        this.backButton.setText(backText);
        this.startButton.setText(submitText);
    }

    public void addForm(String tabName, AbstractForm form) {
        if (form == null) {
            return;
        }
        super.addTab(tabName, form);
        this.forms.add(form);
    }

    public void addFormListener(NewGameTab.GroupFormListener<OUTPUT> formListener) {
        if (formListener == null) {
            return;
        }
        if (this.listeners.contains(formListener)) {
            return;
        }
        this.listeners.add(formListener);
    }

    public void removeFormListener(NewGameTab.GroupFormListener formListener) {
        if (formListener == null) {
            return;
        }
        this.listeners.add(formListener);
    }

    protected void notifyOnBack() {
        for (NewGameTab.GroupFormListener formListener : this.listeners) {
            formListener.onBack();
        }
    }

    protected void notifyOnValidate(ValidationResult validationResult) {
        for (NewGameTab.GroupFormListener formListener : this.listeners) {
            formListener.onValidate(validationResult);
        }
    }

    protected void notifyOnFinished(OUTPUT object) {
        for (NewGameTab.GroupFormListener formListener : this.listeners) {
            formListener.onFinished(object);
        }
    }

    @Override
    public void construct() {
        this.pad(15.0f);
        super.construct();
        this.row();
        Table buttonTable = new Table();
        buttonTable.add(this.backButton).left();
        buttonTable.add().minSize(120.0f, 50.0f).padLeft(25.0f).padRight(25.0f);
        buttonTable.add(this.startButton).right();
        buttonTable.pack();
        this.add(buttonTable).fill();
        this.pack();
    }

    public Form.ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void validateForms() {
        ValidationResult validationResult = new ValidationResult();
        switch (this.validationMode) {
            case ALL: {
                for (Form form : this.forms) {
                    form.validateForm(validationResult);
                }
            }
            case SOLO: {
                if (!(this.stackController.getCurrentContent() instanceof Form)) break;
                Form form = (Form)((Object)this.stackController.getCurrentContent());
                form.validateForm(validationResult);
            }
        }
        this.validationStatus = validationResult.getStatus();
        this.showValidationResults(validationResult);
        this.notifyOnValidate(validationResult);
        if (validationResult.getStatus() == Form.ValidationStatus.VALID) {
            this.notifyOnFinished(this.getObject());
        }
    }

    public void showValidationResults(ValidationResult validationResult) {
        switch (validationResult.getStatus()) {
            case VALID: {
                this.messageLabel.setStyle(this.getSkin().get("empty", IconLabel.IconLabelStyle.class));
                break;
            }
            case INVALID: {
                this.messageLabel.setStyle(this.getSkin().get("warning", IconLabel.IconLabelStyle.class));
                break;
            }
            case UNTOUCHED: {
                this.messageLabel.setStyle(this.getSkin().get("empty", IconLabel.IconLabelStyle.class));
            }
        }
        for (ValidationResult.ValidationMessage message : validationResult.getMessages()) {
            AstraXApp.astraX.showMessageAlert(new Message(Message.MessageType.EXCEPTION, message.message));
        }
        if (validationResult.getStatus() == Form.ValidationStatus.VALID && this.successMessage != null) {
            AstraXApp.astraX.showSuccessAlert(this.successMessage);
        }
    }

    public abstract OUTPUT getObject();

    public static enum ValidationMode {
        ALL,
        SOLO;

    }
}

