/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.forms;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.FormContainer;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import java.util.ArrayList;
import java.util.List;

public class Wizard
extends AstraXComponent {
    private boolean resettable = false;
    private FormContainer.FormContainerStyle formContainerStyle;
    private AbstractForm currentForm = null;
    private List<AbstractForm> forms = new ArrayList<AbstractForm>();
    private Stack formStack;
    private StackController formStackController;
    private TextButton startButton;
    private TextButton backButton;
    private Button nextButton;
    private Button previousButton;
    private TextButton resetButton;
    private Table buttonGroup;
    private Label messageLabel;
    private ValidationResult validationResult;
    private List<DefaultFormListener> defaultFormListeners = new ArrayList<DefaultFormListener>();
    private List<WizardListener> wizardLsteners = new ArrayList<WizardListener>();

    public Wizard(ComponentFactory componentFactory) {
        super(componentFactory);
        this.formStack = new Stack();
        this.formStackController = new StackController(this.formStack);
        this.formStackController.setCyclic(false);
        this.formContainerStyle = componentFactory.getSkin().get(FormContainer.FormContainerStyle.class);
        this.messageLabel = new Label((CharSequence)"", this.formContainerStyle.untouchedLabel);
        this.buttonGroup = new Table(componentFactory.getSkin());
        this.startButton = new TextButton("Start", this.formContainerStyle.submitButtonStyle);
        this.startButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.startButton.setDisabled(true);
        this.startButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null && !Wizard.this.startButton.isDisabled()) {
                    for (WizardListener wizardListener : Wizard.this.wizardLsteners) {
                        wizardListener.onWizardFinished();
                    }
                }
            }
        });
        this.backButton = new TextButton("Back", this.formContainerStyle.cancelButtonStyle);
        this.backButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                for (WizardListener wizardListener : Wizard.this.wizardLsteners) {
                    wizardListener.onWizardBack();
                }
            }
        });
        this.previousButton = new Button(componentFactory.getSkin(), "arrow-left-no-checked");
        this.previousButton.addListener(componentFactory.getButtonSoundListener(this.formContainerStyle.cancelButtonSoundsID));
        this.previousButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    Wizard.this.formStackController.previous();
                    Wizard.this.formStackController.show(Wizard.this.formStackController.getCurrentContent());
                    for (DefaultFormListener defaultFormListener : Wizard.this.defaultFormListeners) {
                        defaultFormListener.onFormCancel(Wizard.this.currentForm);
                    }
                    for (WizardListener wizardListener : Wizard.this.wizardLsteners) {
                        wizardListener.onWizardFormChanged(Wizard.this.currentForm);
                    }
                    Wizard.this.startButton.setDisabled(!Wizard.this.formStackController.isShowingLast());
                    event.stop();
                }
            }
        });
        this.resetButton = new TextButton("Reset", this.formContainerStyle.resetButtonStyle);
        this.resetButton.getLabelCell().pad(this.formContainerStyle.buttonInnerPadding);
        this.resetButton.addListener(componentFactory.getButtonSoundListener(this.formContainerStyle.resetButtonSoundsID));
        this.resetButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    Wizard.this.resetCurrentForm();
                    for (DefaultFormListener defaultFormListener : Wizard.this.defaultFormListeners) {
                        defaultFormListener.onFormReset(Wizard.this.currentForm);
                    }
                    event.stop();
                }
            }
        });
        this.nextButton = new Button(componentFactory.getSkin(), "arrow-right-no-checked");
        this.nextButton.addListener(componentFactory.getButtonSoundListener(this.formContainerStyle.submitButtonSoundsID));
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null) {
                    Wizard.this.validateCurrentForm();
                    switch (Wizard.this.getValidationResult().getStatus()) {
                        case VALID: {
                            Wizard.this.formStackController.next();
                            Wizard.this.formStackController.show(Wizard.this.formStackController.getCurrentContent());
                            for (WizardListener wizardListener : Wizard.this.wizardLsteners) {
                                wizardListener.onWizardFormChanged(Wizard.this.currentForm);
                            }
                            Wizard.this.startButton.setDisabled(!Wizard.this.formStackController.isShowingLast());
                        }
                    }
                    event.stop();
                }
            }
        });
    }

    public void addFormListener(DefaultFormListener defaultFormListener) {
        if (defaultFormListener == null) {
            return;
        }
        this.defaultFormListeners.add(defaultFormListener);
    }

    public void addWizardListener(WizardListener wizardListener) {
        if (wizardListener == null) {
            return;
        }
        this.wizardLsteners.add(wizardListener);
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public AbstractForm getCurrentForm() {
        return this.currentForm;
    }

    public void setCurrentForm(AbstractForm currentForm) {
        this.currentForm = currentForm;
    }

    @Override
    public void construct() {
        this.clear();
        this.buttonGroup.add(this.backButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f).fill();
        this.buttonGroup.add(this.previousButton).size(24.0f, 24.0f);
        if (this.resettable) {
            this.buttonGroup.add(this.resetButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f);
        } else {
            this.buttonGroup.add().fill().pad(2.0f);
        }
        this.buttonGroup.add(this.nextButton).size(24.0f, 24.0f);
        this.buttonGroup.add(this.startButton).minSize(this.formContainerStyle.minButtonWidth, this.formContainerStyle.minButtonHeight).pad(2.0f).fill();
        this.buttonGroup.pack();
        this.add(this.formStack).fill();
        this.row();
        this.add(this.messageLabel).minHeight(50.0f).padLeft(10.0f).padRight(10.0f).padBottom(10.0f).fillX();
        this.row();
        this.add(this.buttonGroup).fill();
        this.pack();
    }

    public void resetCurrentForm() {
        this.messageLabel.setText("");
        this.messageLabel.setStyle(this.formContainerStyle.untouchedLabel);
        this.currentForm.resetStyles();
        this.currentForm.resetForm();
    }

    public void resetAllForms() {
        this.messageLabel.setText("");
        this.messageLabel.setStyle(this.formContainerStyle.untouchedLabel);
        for (AbstractForm form : this.forms) {
            form.resetStyles();
            form.resetForm();
        }
    }

    public void start() {
        this.formStackController.show(0);
        this.currentForm = this.forms.get(0);
    }

    public void addForm(AbstractForm form) {
        this.forms.add(form);
        this.formStack.add(form);
    }

    private void validateCurrentForm() {
        this.currentForm.resetStyles();
        this.validationResult = this.currentForm.validateForm(null);
        this.showValidationResults(this.validationResult);
        for (DefaultFormListener defaultFormListener : this.defaultFormListeners) {
            defaultFormListener.onFormSubmit(this.currentForm);
        }
    }

    public void showValidationResults(ValidationResult validationResult) {
        this.validationResult = validationResult;
        switch (validationResult.getStatus()) {
            case VALID: {
                this.messageLabel.setStyle(this.formContainerStyle.submitLabel);
                break;
            }
            case INVALID: {
                this.messageLabel.setStyle(this.formContainerStyle.errorLabel);
                break;
            }
            case UNTOUCHED: {
                this.messageLabel.setStyle(this.formContainerStyle.warningLabel);
            }
        }
        String messages = "";
        for (ValidationResult.ValidationMessage message : validationResult.getMessages()) {
            String string = messages = messages.isEmpty() ? "- " + message.message : messages + "\n- " + message.message;
            if (message.component == null) continue;
        }
        this.messageLabel.setText(messages);
    }

    public static class WizardStyle {
        public String backButtonSoundsID;
        public TextButton.TextButtonStyle backButtonStyle;
        public String submitButtonSoundsID;
        public TextButton.TextButtonStyle submitButtonStyle;
        public String nextButtonSoundsID;
        public Button.ButtonStyle nextButtonStyle;
        public String previousButtonSoundsID;
        public Button.ButtonStyle previousButtonStyle;
    }

    public static interface WizardListener {
        public void onWizardBack();

        public void onWizardFormChanged(AbstractForm var1);

        public void onWizardFinished();
    }
}

