/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.menu;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DropdownMenu
extends Group {
    private ComponentFactory factory;
    private ButtonGroup<AstraXTextButton> buttonSelection = new ButtonGroup();
    private HorizontalGroup buttons = new HorizontalGroup();
    private java.util.List<Dropdown> dropDowns = new ArrayList<Dropdown>();

    public DropdownMenu(ComponentFactory componentFactory) {
        this.factory = componentFactory;
        this.buttons.space(4.0f);
        this.buttonSelection.setMaxCheckCount(1);
        this.buttonSelection.setMinCheckCount(0);
        this.buttonSelection.setUncheckLast(true);
        this.addActor(this.buttons);
    }

    public void addDropDown(String buttonText, SelectBoxWrapper<Runnable>[] dropDownChoices) {
        AstraXTextButton button = this.factory.getTextButton("dropDown", buttonText, "dropDown");
        button.setCanCheck(true);
        button.setName("DropDown.TextButton." + buttonText);
        List<SelectBoxWrapper<Runnable>> dropDown = new List<SelectBoxWrapper<Runnable>>(this.factory.getSkin());
        dropDown.setName("DropDown.Menu." + buttonText);
        this.dropDowns.add(new Dropdown(button, dropDown));
        dropDown.setItems(dropDownChoices);
        dropDown.pack();
        this.buttonSelection.add(button);
        this.buttons.addActor(button);
        this.addActor(dropDown);
        dropDown.addAction(Tweening.getDropDownFadeOut(0.0f));
        this.buttons.pack();
    }

    public HorizontalGroup getButtons() {
        return this.buttons;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        for (Dropdown dropdown : this.dropDowns) {
            dropdown.update(delta);
        }
    }

    private static class Dropdown {
        private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
        private float maxTimeout;
        private float timeout = this.maxTimeout = 2.0f;
        private boolean hovering = false;
        private AstraXTextButton button;
        private List<SelectBoxWrapper<Runnable>> dropDown;

        public Dropdown(AstraXTextButton textButton, List<SelectBoxWrapper<Runnable>> dropDownMenu) {
            this.button = textButton;
            this.dropDown = dropDownMenu;
            this.dropDown.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    Dropdown.this.button.setChecked(false);
                    if (Dropdown.this.dropDown.getSelected() != null) {
                        Dropdown.this.logger.fine("Performing action!");
                        ((Runnable)((SelectBoxWrapper)Dropdown.this.dropDown.getSelected()).getPayload()).run();
                        event.handle();
                    }
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    super.enter(event, x, y, pointer, fromActor);
                    Dropdown.this.hovering = true;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    super.exit(event, x, y, pointer, toActor);
                    Dropdown.this.hovering = false;
                    if (!Dropdown.this.button.isChecked()) {
                        Dropdown.this.logger.finest("Fade out from dropdown");
                        Dropdown.this.dropDown.addAction(Tweening.getDropDownFadeOut(0.1f));
                        event.handle();
                    }
                }
            });
            this.button.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (Dropdown.this.button.isChecked()) {
                        Dropdown.this.logger.finest("Fade In from button");
                        Dropdown.this.dropDown.toFront();
                        Dropdown.this.dropDown.setPosition(Dropdown.this.button.getX(), 0.0f, 10);
                        Dropdown.this.dropDown.addAction(Tweening.getDropDownFadeIn(0.1f));
                        Dropdown.this.timeout = Dropdown.this.maxTimeout;
                        event.handle();
                    } else {
                        Dropdown.this.logger.finest("Fade Out from button");
                        Dropdown.this.dropDown.addAction(Tweening.getDropDownFadeOut(0.3f));
                        event.handle();
                    }
                }
            });
        }

        public void update(float delta) {
            if (this.hovering) {
                this.timeout = this.maxTimeout;
            } else {
                if (this.timeout > 0.0f) {
                    this.timeout *= 0.92f - delta;
                }
                if (this.timeout < 1.0E-4f && this.dropDown.isVisible()) {
                    this.dropDown.addAction(Tweening.getDropDownFadeOut(0.3f));
                    this.button.setChecked(false);
                    this.timeout = 0.0f;
                }
            }
        }
    }
}

