/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.panels;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.lang.Translatable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.Background;
import com.neutronio.astrax.ui.commons.Separator;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public abstract class AbstractPanel
extends AstraXComponent
implements Translatable {
    protected AbstractPanelStyle panelStyle;

    public AbstractPanel(ComponentFactory componentFactory) {
        super(componentFactory, null);
        this.setStyle(componentFactory.getSkin().get(AbstractPanelStyle.class));
    }

    public AbstractPanel(ComponentFactory componentFactory, String style) {
        super(componentFactory);
        this.setStyle(componentFactory.getSkin().get(style, AbstractPanelStyle.class));
    }

    protected AbstractPanel(ComponentFactory componentFactory, AbstractPanelStyle style, String backgroundStyle) {
        super(componentFactory);
        this.setStyle(style);
        if (backgroundStyle != null) {
            this.setBackgroundStyle(componentFactory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class));
        }
    }

    public AbstractPanel(ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory);
        this.setStyle(componentFactory.getSkin().get(style, AbstractPanelStyle.class));
        if (backgroundStyle != null) {
            this.setBackgroundStyle(componentFactory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class));
        }
    }

    public void setStyle(AbstractPanelStyle abstractPanelStyle) {
        this.panelStyle = abstractPanelStyle;
    }

    public AbstractPanelStyle getStyle() {
        return this.panelStyle;
    }

    @Override
    public void translate() {
        this.construct();
    }

    public abstract void resetValues();

    public void addRow(String labelText, Actor valueWidget, int valueColspan) {
        this.addLabel(labelText);
        this.addValue(valueWidget, valueColspan);
    }

    public void addRow(String labelText, Actor valueWidget) {
        this.addLabel(labelText);
        this.addValue(valueWidget, 1);
    }

    public Cell<Actor> addValue(Actor widget, int colspan) {
        return this.add(widget).minWidth(this.panelStyle.minValueWidth).maxWidth(this.panelStyle.maxValueWidth).fill().colspan(colspan).padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
    }

    public Cell<Actor> addValue(Actor widget) {
        return this.addValue(widget, 1);
    }

    public Cell<Actor> addValueCentered(Actor widget) {
        return this.addValueCentered(widget, 1);
    }

    public Cell<Actor> addValueCentered(Actor widget, int colspan) {
        return this.add(widget).center().colspan(colspan).pad((float)this.panelStyle.columnPadding / 2.0f);
    }

    public AstraXLabel addLabel(String labelText) {
        return this.addLabel(labelText, 1);
    }

    public AstraXLabel addLabel(String labelText, int colspan) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, labelText, this.panelStyle.labelStyle, this.panelStyle.labelBackgroundStyle);
        this.add(label).left().minWidth(this.panelStyle.minLabelWidth).maxWidth(this.panelStyle.maxLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding).colspan(colspan).fill();
        return label;
    }

    public AstraXLabel addLabel(String labelText, String labelStyle) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, labelText, this.componentFactory.getSkin().get(labelStyle, Label.LabelStyle.class), this.panelStyle.labelBackgroundStyle);
        this.add(label).left().minWidth(this.panelStyle.minLabelWidth).maxWidth(this.panelStyle.maxLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding).colspan(1);
        return label;
    }

    protected AstraXLabel getLabel(String text) {
        return new AstraXLabel(this.componentFactory, text, this.panelStyle.labelStyle, this.panelStyle.labelBackgroundStyle);
    }

    protected AstraXLabel getHeader(String text) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, text, this.panelStyle.headerStyle, this.panelStyle.headerBackgroundStyle);
        label.setAlignment(1, 1);
        label.setAlignment(1);
        return label;
    }

    protected AstraXLabel getHeader2(String text) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, text, this.panelStyle.header2Style, this.panelStyle.header2BackgroundStyle);
        label.setAlignment(1, 1);
        label.setAlignment(1);
        return label;
    }

    public AstraXLabel addHeader(String labelText, int colspan) {
        AstraXLabel label = this.getHeader(labelText);
        this.add(label).center().padBottom((float)this.panelStyle.rowPadding * 3.0f).colspan(colspan).fill();
        return label;
    }

    public AstraXLabel addHeader(String labelText, float minWidth, int colspan) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, labelText, this.panelStyle.headerStyle, this.panelStyle.headerBackgroundStyle);
        label.setAlignment(1, 1);
        this.add(label).center().minWidth(minWidth).padBottom((float)this.panelStyle.rowPadding * 3.0f).colspan(colspan).fill();
        return label;
    }

    public AstraXLabel addHeader2(String labelText, int colspan) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, labelText, this.panelStyle.header2Style, this.panelStyle.header2BackgroundStyle);
        label.setAlignment(1, 1);
        this.add(label).center().padBottom((float)this.panelStyle.rowPadding * 3.0f).colspan(colspan).fill();
        return label;
    }

    public void addHeader2(String labelText) {
        this.addHeader2(labelText, 1);
    }

    public void addSeparator(float minHeight, float minWidth, int colspan) {
        this.add(new Separator(this.getSkin(), "icon_bg_rhombus_t50_w_n")).center().minSize(minWidth, minHeight).padBottom(this.panelStyle.rowPadding).colspan(colspan).fill();
    }

    public static class AbstractPanelStyle {
        public Label.LabelStyle labelStyle;
        public Background.BackgroundStyle labelBackgroundStyle;
        public Label.LabelStyle headerStyle;
        public Background.BackgroundStyle headerBackgroundStyle;
        public Label.LabelStyle header2Style;
        public Background.BackgroundStyle header2BackgroundStyle;
        public int columnPadding = 20;
        public int rowPadding = 5;
        public int minLabelWidth = 70;
        public int minValueWidth = 200;
        public int maxLabelWidth = Integer.MAX_VALUE;
        public int maxValueWidth = Integer.MAX_VALUE;
    }
}

