/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.panels;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;

public class Accordion<T extends Actor>
extends Group {
    private Table header;
    private AstraXButton button;
    private Label label;
    private T panel;

    public Accordion(ComponentFactory componentFactory, T actor) {
        if (actor == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "actor can't be null!");
        }
        this.panel = actor;
        this.header = new Table();
        this.header.left();
        this.label = new Label((CharSequence)"Header", componentFactory.getSkin());
        this.button = new AstraXButton(componentFactory, "icon_inline_arrow_right", "default");
        this.button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (Accordion.this.panel.hasParent()) {
                    Accordion.this.contract();
                    Accordion.this.button.getInlineIcon().addAction(Actions.rotateBy(90.0f, 0.3f));
                } else {
                    Accordion.this.expand();
                    Accordion.this.button.getInlineIcon().addAction(Actions.rotateBy(-90.0f, 0.1f));
                }
            }
        });
        this.header.add(this.button).padRight(5.0f);
        this.header.add(this.label).fill();
        this.header.setWidth(((Actor)this.panel).getWidth());
        this.header.pack();
        ((Actor)this.panel).setPosition(0.0f, 0.0f);
        ((Actor)this.panel).setVisible(false);
        this.addActor(this.header);
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public void expand() {
        this.addActor((Actor)this.panel);
        ((Actor)this.panel).addAction(Actions.sequence((Action)Actions.delay(0.1f), (Action)Actions.show(), (Action)Actions.fadeIn(0.1f)));
        float newHeight = this.header.getHeight() + ((Actor)this.panel).getHeight();
        float maxWidth = Math.max(this.header.getWidth(), ((Actor)this.panel).getWidth());
        this.addAction(Actions.parallel((Action)Actions.sizeTo(maxWidth, this.header.getHeight() + ((Actor)this.panel).getHeight(), 0.2f), (Action)Actions.moveBy(0.0f, -newHeight + this.header.getHeight(), 0.2f)));
        this.header.addAction(Actions.moveTo(0.0f, newHeight - this.header.getHeight(), 0.2f));
    }

    public void contract() {
        float newHeight = this.header.getHeight() + ((Actor)this.panel).getHeight();
        ((Actor)this.panel).addAction(Actions.sequence((Action)Actions.fadeOut(0.15f), (Action)Actions.hide(), (Action)Actions.removeActor()));
        this.addAction(Actions.parallel((Action)Actions.sizeTo(this.header.getWidth(), this.header.getHeight(), 0.3f), (Action)Actions.moveBy(0.0f, newHeight - this.header.getHeight(), 0.3f)));
        this.header.addAction(Actions.moveTo(0.0f, 0.0f, 0.3f));
    }
}

