/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.tab;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import java.util.ArrayList;
import java.util.List;

public class FlexTab
extends AstraXComponent {
    protected ButtonGroup<Button> tabButtonGroup;
    protected List<Button> tabButtons;
    protected Stack contentStack;
    protected List<TabContent> contents = new ArrayList<TabContent>();
    protected StackController stackController;

    public FlexTab(ComponentFactory componentFactory) {
        this(componentFactory, "tab");
    }

    public FlexTab(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, backgroundStyle);
        this.tabButtonGroup = new ButtonGroup();
        this.tabButtonGroup.setMaxCheckCount(1);
        this.tabButtonGroup.setMinCheckCount(1);
        this.tabButtonGroup.setUncheckLast(true);
        this.tabButtons = new ArrayList<Button>();
        this.contentStack = new Stack();
        this.stackController = new StackController(this.contentStack);
    }

    public StackController getStackController() {
        return this.stackController;
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
    }

    public AstraXButton addTabWithIconButton(String buttonStyle, String iconDrawable, Group content) {
        content.setVisible(false);
        this.contentStack.add(content);
        AstraXButton tabButton = new AstraXButton(this.componentFactory, iconDrawable, buttonStyle);
        TabContent tabContent = new TabContent(tabButton, content);
        tabButton.addListener(tabContent);
        this.tabButtonGroup.add(tabButton);
        this.tabButtons.add(tabButton);
        this.contents.add(tabContent);
        return tabButton;
    }

    public AstraXTextButton addTabWithTextButton(String title, String textButtonStyle, Group content) {
        content.setVisible(false);
        this.contentStack.add(content);
        AstraXTextButton tabButton = new AstraXTextButton(this.componentFactory, textButtonStyle);
        tabButton.setTextAlign(1);
        tabButton.setText(title);
        tabButton.setSquishable(false);
        TabContent tabContent = new TabContent(tabButton, content);
        tabButton.addListener(tabContent);
        this.tabButtonGroup.add(tabButton);
        this.tabButtons.add(tabButton);
        this.contents.add(tabContent);
        return tabButton;
    }

    public void addTabWithButton(Button button, Group content) {
        content.setVisible(false);
        this.contentStack.add(content);
        TabContent tabContent = new TabContent(button, content);
        if (!(button instanceof Actor)) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Button must be an actor");
        }
        ((Actor)((Object)button)).addListener(tabContent);
        this.tabButtonGroup.add(button);
        this.tabButtons.add(button);
        this.contents.add(tabContent);
    }

    public List<Button> getTabButtons() {
        return this.tabButtons;
    }

    public Stack getContentStack() {
        return this.contentStack;
    }

    private class TabContent
    extends ClickListener {
        private boolean hidden = false;
        private Button tabButton;
        private Group tabContent;

        public TabContent(Button tabButton, Group tabContent) {
            this.tabButton = tabButton;
            this.tabContent = tabContent;
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            super.clicked(event, x, y);
            if (this.tabButton.isDisabled()) {
                return;
            }
            FlexTab.this.stackController.show(this.tabContent);
        }
    }
}

