/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.tab;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.StackController;

public class IconTab
extends AstraXComponent {
    protected IconTabStyle style;
    protected ButtonGroup<AstraXButton> tabButtonGroup;
    protected Table tabButtons;
    protected Stack contentStack;
    protected StackController stackController;

    public IconTab(ComponentFactory factory, String styleName) {
        super(factory);
        this.setStyle(factory.getSkin().get(styleName, IconTabStyle.class));
        this.tabButtonGroup = new ButtonGroup();
        this.tabButtonGroup.setMaxCheckCount(1);
        this.tabButtonGroup.setMinCheckCount(1);
        this.tabButtonGroup.setUncheckLast(true);
        this.tabButtons = new Table();
        this.contentStack = new Stack();
        this.stackController = new StackController(this.contentStack);
    }

    public IconTab(ComponentFactory componentFactory) {
        this(componentFactory, "default");
    }

    public void setStyle(IconTabStyle tabStyle) {
        this.style = tabStyle;
        this.setBackground(this.style.background);
    }

    @Override
    public void construct() {
        this.clear();
        this.add(this.tabButtons).pad(10.0f).left();
        this.row();
        this.add(this.contentStack).pad(15.0f);
        this.pack();
        this.stackController.show(0);
    }

    public void addTab(String inlineIcon, final Group content) {
        content.setVisible(false);
        this.contentStack.add(content);
        AstraXButton tabButton = new AstraXButton(this.componentFactory, inlineIcon, this.style.baseButtonStyle);
        tabButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                IconTab.this.stackController.show(content);
            }
        });
        this.tabButtonGroup.add(tabButton);
        this.tabButtons.add(tabButton).padRight(5.0f);
    }

    public static class IconTabStyle {
        public Drawable background;
        public String baseButtonStyle;
    }
}

