/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.tab;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.Background;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Tab
extends AstraXComponent {
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected TabStyle tabStyle;
    protected ButtonGroup<AstraXTextButton> tabButtonGroup;
    protected Table tabButtons;
    protected Stack contentStack;
    protected List<TabContent> contents = new ArrayList<TabContent>();
    protected StackController stackController;

    public Tab(ComponentFactory factory, String styleName, String backgroundStyle) {
        super(factory);
        this.setTabStyle(factory.getSkin().get(styleName, TabStyle.class));
        if (backgroundStyle != null) {
            this.setBackgroundStyle(factory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class));
        }
        this.tabButtonGroup = new ButtonGroup();
        this.tabButtonGroup.setMaxCheckCount(1);
        this.tabButtonGroup.setMinCheckCount(1);
        this.tabButtonGroup.setUncheckLast(true);
        this.tabButtons = new Table();
        this.contentStack = new Stack();
        this.stackController = new StackController(this.contentStack);
    }

    public TabStyle getTabStyle() {
        return this.tabStyle;
    }

    public void setTabStyle(TabStyle tabStyle) {
        this.tabStyle = tabStyle;
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.add(this.tabButtons).padTop(5.0f).padBottom(10.0f).left();
        this.row();
        this.add(this.contentStack).padBottom(15.0f);
        this.pack();
        this.stackController.show(0);
    }

    public void toggleTab(Class clazz) {
        for (TabContent content : this.contents) {
            if (!clazz.isInstance(content.tabContent)) continue;
            content.hidden = !content.hidden;
            this.updateTabButtons();
            break;
        }
    }

    public void setTabVisible(Class clazz, boolean visible) {
        for (TabContent content : this.contents) {
            if (!clazz.isInstance(content.tabContent)) continue;
            content.hidden = !visible;
            this.updateTabButtons();
            break;
        }
    }

    public boolean isTabVisible(Class clazz) {
        for (TabContent content : this.contents) {
            if (!clazz.isInstance(content.tabContent)) continue;
            return !content.hidden;
        }
        return false;
    }

    private void updateTabButtons() {
        this.tabButtons.clear();
        for (TabContent tabContent : this.contents) {
            if (tabContent.hidden) continue;
            this.tabButtons.add(tabContent.tabButton).padRight(5.0f);
        }
        this.tabButtons.pack();
    }

    public void addTab(String title, Group content) {
        content.setVisible(false);
        this.contentStack.add(content);
        AstraXTextButton tabButton = new AstraXTextButton(this.componentFactory, this.tabStyle.tabButtonStyle);
        tabButton.setTextAlign(1);
        tabButton.setText(title);
        TabContent tabContent = new TabContent(tabButton, content);
        tabButton.addListener(tabContent);
        this.tabButtonGroup.add(tabButton);
        this.tabButtons.add(tabButton).padRight(5.0f);
        this.contents.add(tabContent);
    }

    public static class TabStyle {
        public Background.BackgroundStyle backgroundStyle;
        public String tabButtonStyle;
    }

    private class TabContent
    extends ClickListener {
        private boolean hidden = false;
        private AstraXTextButton tabButton;
        private Group tabContent;

        public TabContent(AstraXTextButton tabButton, Group tabContent) {
            this.tabButton = tabButton;
            this.tabContent = tabContent;
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            super.clicked(event, x, y);
            Tab.this.stackController.show(this.tabContent);
        }
    }
}

