/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.StringBuilder;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;

public class AstraXLabel
extends Widget {
    private static final Color tempColor = new Color();
    private static final GlyphLayout prefSizeLayout = new GlyphLayout();
    protected Background background;
    protected ComponentFactory componentFactory;
    protected Label.LabelStyle style;
    protected final GlyphLayout layout = new GlyphLayout();
    protected final Vector2 prefSize = new Vector2();
    protected final StringBuilder text = new StringBuilder();
    protected int intValue = Integer.MIN_VALUE;
    protected BitmapFontCache cache;
    protected int labelAlign = 8;
    protected int lineAlign = 8;
    protected boolean wrap;
    protected float lastPrefHeight;
    protected boolean prefSizeInvalid = true;
    protected float fontScaleX = 1.0f;
    protected float fontScaleY = 1.0f;
    protected boolean fontScaleChanged = false;
    @Null
    protected String ellipsis;

    public AstraXLabel(ComponentFactory componentFactory, String backgroundStyle) {
        this(componentFactory, "", "default", backgroundStyle);
    }

    public AstraXLabel(ComponentFactory componentFactory, String text, Label.LabelStyle labelStyle, String backgroundStyle) {
        this(componentFactory, text, labelStyle, backgroundStyle != null ? componentFactory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class) : null);
    }

    public AstraXLabel(ComponentFactory componentFactory, String text, String labelStyle, String backgroundStyle) {
        this(componentFactory, text, labelStyle != null ? componentFactory.getSkin().get(labelStyle, Label.LabelStyle.class) : componentFactory.getSkin().get("default", Label.LabelStyle.class), backgroundStyle != null ? componentFactory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class) : null);
    }

    public AstraXLabel(ComponentFactory componentFactory, String text, Label.LabelStyle labelStyle, Background.BackgroundStyle backgroundStyle) {
        this.componentFactory = componentFactory;
        if (text != null) {
            this.text.append(text);
        }
        this.setStyle(labelStyle);
        if (backgroundStyle != null) {
            this.setBackgroundStyle(backgroundStyle);
        }
        if (text != null && text.length() > 0) {
            this.setSize(this.getPrefWidth(), this.getPrefHeight());
        }
    }

    public void setStyle(Label.LabelStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        if (style.font == null) {
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        this.style = style;
        this.cache = style.font.newFontCache();
        this.invalidateHierarchy();
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackgroundStyle(Background.BackgroundStyle backgroundStyle) {
        if (backgroundStyle == null && this.background != null) {
            this.background.remove();
            return;
        }
        if (this.background != null) {
            this.background.setStyle(backgroundStyle);
        } else {
            this.background = new Background(this.componentFactory.getSkin(), backgroundStyle);
        }
    }

    public Label.LabelStyle getStyle() {
        return this.style;
    }

    public boolean setText(int value) {
        if (this.intValue == value) {
            return false;
        }
        this.text.clear();
        this.text.append(value);
        this.intValue = value;
        this.invalidateHierarchy();
        return true;
    }

    public void setText(@Null CharSequence newText) {
        if (newText == null) {
            if (this.text.length == 0) {
                return;
            }
            this.text.clear();
        } else if (newText instanceof StringBuilder) {
            if (this.text.equals(newText)) {
                return;
            }
            this.text.clear();
            this.text.append((StringBuilder)newText);
        } else {
            if (this.textEquals(newText)) {
                return;
            }
            this.text.clear();
            this.text.append(newText);
        }
        this.intValue = Integer.MIN_VALUE;
        this.invalidateHierarchy();
    }

    public boolean textEquals(CharSequence other) {
        int length = this.text.length;
        char[] chars = this.text.chars;
        if (length != other.length()) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (chars[i2] == other.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public StringBuilder getText() {
        return this.text;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    private void scaleAndComputePrefSize() {
        BitmapFont font = this.cache.getFont();
        float oldScaleX = font.getScaleX();
        float oldScaleY = font.getScaleY();
        if (this.fontScaleChanged) {
            font.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        this.computePrefSize();
        if (this.fontScaleChanged) {
            font.getData().setScale(oldScaleX, oldScaleY);
        }
    }

    private void computePrefSize() {
        this.prefSizeInvalid = false;
        GlyphLayout prefSizeLayout = AstraXLabel.prefSizeLayout;
        if (this.wrap && this.ellipsis == null) {
            float width = this.getWidth();
            if (this.style.background != null) {
                width = Math.max(width, this.style.background.getMinWidth()) - this.style.background.getLeftWidth() - this.style.background.getRightWidth();
            }
            prefSizeLayout.setText(this.cache.getFont(), this.text, Color.WHITE, width, 8, true);
        } else {
            prefSizeLayout.setText(this.cache.getFont(), this.text);
        }
        this.prefSize.set(prefSizeLayout.width, prefSizeLayout.height);
    }

    @Override
    public void layout() {
        float textHeight;
        float textWidth;
        float prefHeight;
        boolean wrap;
        BitmapFont font = this.cache.getFont();
        float oldScaleX = font.getScaleX();
        float oldScaleY = font.getScaleY();
        if (this.fontScaleChanged) {
            font.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        boolean bl = wrap = this.wrap && this.ellipsis == null;
        if (wrap && (prefHeight = this.getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = prefHeight;
            this.invalidateHierarchy();
        }
        float width = this.getWidth();
        float height = this.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        if (this.background != null) {
            x = this.background.getDrawable().getLeftWidth();
            y = this.background.getDrawable().getBottomHeight();
            width -= this.background.getDrawable().getLeftWidth() + this.background.getDrawable().getRightWidth();
            height -= this.background.getDrawable().getBottomHeight() + this.background.getDrawable().getTopHeight();
        }
        GlyphLayout layout = this.layout;
        if (wrap || this.text.indexOf("\n") != -1) {
            layout.setText(font, this.text, 0, this.text.length, Color.WHITE, width, this.lineAlign, wrap, this.ellipsis);
            textWidth = layout.width;
            textHeight = layout.height;
            if ((this.labelAlign & 8) == 0) {
                x = (this.labelAlign & 0x10) != 0 ? (x += width - textWidth) : (x += (width - textWidth) / 2.0f);
            }
        } else {
            textWidth = width;
            textHeight = font.getData().capHeight;
        }
        if ((this.labelAlign & 2) != 0) {
            y += this.cache.getFont().isFlipped() ? 0.0f : height - textHeight;
            y += this.style.font.getDescent();
        } else if ((this.labelAlign & 4) != 0) {
            y += this.cache.getFont().isFlipped() ? height - textHeight : 0.0f;
            y -= this.style.font.getDescent();
        } else {
            y += (height - textHeight) / 2.0f;
        }
        if (!this.cache.getFont().isFlipped()) {
            y += textHeight;
        }
        layout.setText(font, this.text, 0, this.text.length, Color.WHITE, textWidth, this.lineAlign, wrap, this.ellipsis);
        this.cache.setText(layout, x, y);
        if (this.fontScaleChanged) {
            font.getData().setScale(oldScaleX, oldScaleY);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = tempColor.set(this.getColor());
        color.a *= parentAlpha;
        if (this.background != null) {
            this.background.setColor(this.background.getCurrentColor().r, this.background.getCurrentColor().g, this.background.getCurrentColor().b, this.background.getCurrentColor().a * parentAlpha * AstraXLabel.tempColor.a);
            this.background.setSize(this.getWidth(), this.getHeight());
            this.background.setPosition(this.getX(), this.getY());
            this.background.draw(batch, parentAlpha);
        }
        if (this.style.fontColor != null) {
            color.mul(this.style.fontColor);
        }
        this.cache.tint(color);
        this.cache.setPosition(this.getX(), this.getY());
        this.cache.draw(batch);
    }

    @Override
    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float width = this.prefSize.x;
        if (this.background != null) {
            width = Math.max(width + this.background.getDrawable().getLeftWidth() + this.background.getDrawable().getRightWidth(), this.background.getDrawable().getMinWidth());
            width += (float)this.background.getStyle().padding / 2.0f;
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float descentScaleCorrection = 1.0f;
        if (this.fontScaleChanged) {
            descentScaleCorrection = this.fontScaleY / this.style.font.getScaleY();
        }
        float height = this.prefSize.y - this.style.font.getDescent() * descentScaleCorrection * 2.0f;
        if (this.background != null) {
            height = Math.max(height + this.background.getDrawable().getTopHeight() + this.background.getDrawable().getBottomHeight(), this.background.getDrawable().getMinHeight());
            height += (float)this.background.getStyle().padding / 2.0f;
        }
        return height;
    }

    public GlyphLayout getGlyphLayout() {
        return this.layout;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
        this.invalidateHierarchy();
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public int getLineAlign() {
        return this.lineAlign;
    }

    public void setAlignment(int alignment) {
        this.setAlignment(alignment, alignment);
    }

    public void setAlignment(int labelAlign, int lineAlign) {
        this.labelAlign = labelAlign;
        this.lineAlign = (lineAlign & 8) != 0 ? 8 : ((lineAlign & 0x10) != 0 ? 16 : 1);
        this.invalidate();
    }

    public void setFontScale(float fontScale) {
        this.setFontScale(fontScale, fontScale);
    }

    public void setFontScale(float fontScaleX, float fontScaleY) {
        this.fontScaleChanged = true;
        this.fontScaleX = fontScaleX;
        this.fontScaleY = fontScaleY;
        this.invalidateHierarchy();
    }

    public float getFontScaleX() {
        return this.fontScaleX;
    }

    public void setFontScaleX(float fontScaleX) {
        this.setFontScale(fontScaleX, this.fontScaleY);
    }

    public float getFontScaleY() {
        return this.fontScaleY;
    }

    public void setFontScaleY(float fontScaleY) {
        this.setFontScale(this.fontScaleX, fontScaleY);
    }

    public void setEllipsis(@Null String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public void setEllipsis(boolean ellipsis) {
        this.ellipsis = ellipsis ? "..." : null;
    }

    protected BitmapFontCache getBitmapFontCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        String className = this.getClass().getName();
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return (className.indexOf(36) != -1 ? "Label " : "") + className + ": " + this.text;
    }
}

