/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.DefaultPaginator;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class TextPaginator {
    private int charactersPerPage = 300;
    private int charactersPerLine = 35;
    private List<String> pages = new ArrayList<String>();
    private AstraXLabel label;
    private DefaultPaginator defaultPaginator = new DefaultPaginator();
    private PaginatorComponent paginatorComponent;

    public TextPaginator(AstraXLabel label, PaginatorComponent paginatorComponent) {
        this.label = label;
        this.paginatorComponent = paginatorComponent;
        this.paginatorComponent.setPaginator(this.defaultPaginator);
        this.paginatorComponent.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                TextPaginator.this.update();
            }
        });
    }

    public void setCharactersPerPage(int charactersPerPage) {
        this.charactersPerPage = charactersPerPage;
    }

    public void setCharactersPerLine(int charactersPerLine) {
        this.charactersPerLine = charactersPerLine;
    }

    public void setText(String text) {
        this.pages.clear();
        if (text == null || text.isEmpty()) {
            this.defaultPaginator.configure(0, 0);
            return;
        }
        String[] words = text.split(Pattern.quote(" "));
        int charCount = 0;
        StringBuilder strBuffer = new StringBuilder();
        for (String word : words) {
            strBuffer.append(word).append(" ");
            if (charCount > this.charactersPerPage) {
                this.pages.add(strBuffer.toString());
                strBuffer.delete(0, strBuffer.length());
                charCount = 0;
            }
            if (word.equals("\n")) {
                charCount += this.charactersPerLine;
                continue;
            }
            charCount += word.length() + 1;
        }
        if (charCount > 0) {
            this.pages.add(strBuffer.toString());
        }
        this.defaultPaginator.configure(this.pages.size(), 1);
        this.defaultPaginator.setCurrentPage(1);
    }

    public void update() {
        if (this.pages.isEmpty()) {
            this.label.setText("");
            this.paginatorComponent.update();
        } else {
            this.label.setText(this.pages.get(this.defaultPaginator.getCurrentPage() - 1));
            this.paginatorComponent.update();
        }
    }
}

