/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ProgressBar;
import com.neutronio.astrax.util.StandardFormats;

public class TextProgressbar
extends Stack {
    private ProgressBar progressBar;
    private Label label;
    private StandardFormats format = StandardFormats.FACTOR;
    private boolean usePercent;
    private float baseValue = 1.0f;

    public TextProgressbar(ComponentFactory componentFactory) {
        this.progressBar = new ProgressBar(componentFactory);
        this.label = new Label("0", componentFactory.getSkin(), "default-no-bg");
        this.label.setAlignment(1, 1);
        this.label.setTouchable(Touchable.disabled);
        this.add(this.progressBar);
        this.add(this.label);
        this.pack();
    }

    public void setFormat(StandardFormats format) {
        this.format = format;
    }

    public void setValue(float value) {
        this.progressBar.setValue(value);
        if (this.usePercent) {
            this.label.setText(this.format.format(Float.valueOf(value * 100.0f)) + " %");
        } else {
            this.label.setText(this.format.format(Float.valueOf(value * this.baseValue)) + " / " + this.format.format(Float.valueOf(this.baseValue)));
        }
        this.progressBar.setHeight(this.label.getHeight() + 5.0f);
        this.progressBar.pack();
        this.pack();
    }

    public void setUsePercent(boolean usePercent) {
        this.usePercent = usePercent;
    }

    public void setBaseValue(float baseValue) {
        this.baseValue = baseValue;
    }
}

