/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TextSelector<W>
extends AstraXComponent {
    private static String pleaseSelect = "[Select One...]";
    private AstraXButton previousButton;
    private AstraXButton nextButton;
    private Label displayedText;
    private int selectedIndex = -1;
    private List<SelectBoxWrapper<W>> items = new ArrayList<SelectBoxWrapper<W>>();

    public TextSelector(ComponentFactory componentFactory) {
        super(componentFactory, "label");
        this.previousButton = new AstraXButton(componentFactory, "icon_inline_arrow_left", "primary-no-check");
        this.previousButton.setCanCheck(false);
        this.nextButton = new AstraXButton(componentFactory, "icon_inline_arrow_right", "primary-no-check");
        this.nextButton.setCanCheck(false);
        this.displayedText = new Label(pleaseSelect, componentFactory.getSkin(), "default-no-bg");
        this.displayedText.setAlignment(1, 1);
        this.previousButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                TextSelector.this.previous();
            }
        });
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                TextSelector.this.next();
            }
        });
        this.add(this.previousButton).size(this.previousButton.getStyle().width, this.previousButton.getStyle().height).padRight(10.0f).right().align(16);
        this.add(this.displayedText).minWidth(200.0f);
        this.add(this.nextButton).size(this.previousButton.getStyle().width, this.previousButton.getStyle().height).size(24.0f, 24.0f).padLeft(10.0f).left();
    }

    public void setTextSpace(float space) {
        this.getCell(this.displayedText).space(space);
    }

    public void setTextMinWidth(float minWidth) {
        this.getCell(this.displayedText).minWidth(minWidth);
    }

    public void addItem(SelectBoxWrapper<W> wrapper) {
        this.deselect();
        this.items.add(wrapper);
    }

    public void setItems(List<SelectBoxWrapper<W>> items) {
        this.deselect();
        this.items.clear();
        this.items.addAll(items);
    }

    public void setItems(SelectBoxWrapper<W>[] items) {
        this.deselect();
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
    }

    public void clearItems() {
        this.deselect();
        this.items.clear();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public W getSelectedObject() {
        if (this.selectedIndex < 0) {
            return null;
        }
        return this.items.get(this.selectedIndex).getPayload();
    }

    public void deselect() {
        this.selectedIndex = -1;
        this.displayedText.setText(pleaseSelect);
    }

    public void setSelectedIndex(int selectedIndex, boolean fireEvent) {
        if (selectedIndex < 0) {
            return;
        }
        this.selectedIndex = selectedIndex % this.items.size();
        this.displayedText.setText(this.items.get(this.selectedIndex).toString());
        if (fireEvent) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            boolean cancelled = this.fire(changeEvent);
            Pools.free(changeEvent);
        }
    }

    public void setSelected(W selected, boolean fireEvent) {
        int i2 = 0;
        for (SelectBoxWrapper<W> wrapper : this.items) {
            if (Objects.equals(wrapper.getPayload(), selected)) {
                this.setSelectedIndex(i2, fireEvent);
                break;
            }
            ++i2;
        }
    }

    public void next() {
        if (this.items.size() == 0) {
            return;
        }
        this.selectedIndex = (this.selectedIndex + 1) % this.items.size();
        this.displayedText.setText(this.items.get(this.selectedIndex).toString());
        this.fire(new ChangeListener.ChangeEvent());
    }

    public void previous() {
        if (this.items.size() == 0) {
            return;
        }
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.items.size() - 1;
        }
        this.displayedText.setText(this.items.get(this.selectedIndex).toString());
        this.fire(new ChangeListener.ChangeEvent());
    }
}

