/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.AstraXSlider;
import com.neutronio.astrax.util.StandardFormats;

public class TextSlider
extends Table {
    protected AstraXLabel label;
    protected AstraXSlider slider;
    private StandardFormats format = StandardFormats.FACTOR;
    private boolean usePercent = false;
    private float baseValue = 1.0f;

    public TextSlider(ComponentFactory componentFactory) {
        this.label = new AstraXLabel(componentFactory, "0", "default", null);
        this.label.setAlignment(8, 4);
        this.label.setTouchable(Touchable.disabled);
        this.slider = new AstraXSlider(componentFactory);
        this.slider.setValue(0.4f);
        this.add(this.slider).padRight(15.0f);
        this.add(this.label).width(70.0f);
        this.pack();
        this.slider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                TextSlider.this.updateValueText(TextSlider.this.slider.getTargetValue());
            }
        });
    }

    public void setFormat(StandardFormats format) {
        this.format = format;
    }

    public void setValue(float value) {
        this.slider.setValue(value);
        this.updateValueText(value);
    }

    public float getValue() {
        return this.slider.getTargetValue();
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    protected void updateValueText(float value) {
        value = MathUtils.clamp(value, 0.0f, 1.0f);
        if (this.usePercent) {
            this.label.setText(this.format.format(Float.valueOf(value * 100.0f)) + " %");
        } else {
            this.label.setText(this.format.format(Float.valueOf(value * this.baseValue)));
        }
        this.pack();
    }

    public void setUsePercent(boolean usePercent) {
        this.usePercent = usePercent;
        this.updateValueText(this.slider.getTargetValue());
    }

    public void setBaseValue(float baseValue) {
        this.baseValue = baseValue;
    }
}

