/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.text;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;

public class Wiki
extends AstraXComponent {
    private ScrollPane entryScrollPane;
    private Table outerEntryTable;
    private ScrollPane textScrollPane;
    private Table outerTextTable;
    private List<WikiEntry> entries;
    private TextArea textArea;

    public Wiki(ComponentFactory componentFactory) {
        super(componentFactory, "border");
        this.textArea = new TextArea("", componentFactory.getSkin());
        this.textArea.setDisabled(true);
        this.textArea.setPrefRows(10.0f);
        this.entries = new List(componentFactory.getSkin());
        this.entries.setItems((WikiEntry[])new WikiEntry[]{new WikiEntry("Entry 1", "Some Entry text."), new WikiEntry("Entry 2", "Yadda"), new WikiEntry("Entry 3", "Lorem ipsum blablabla")});
        this.entries.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Wiki.this.onSelectedChanged();
            }
        });
        this.entries.addListener(componentFactory.getButtonSoundListener("checkBox"));
        this.entryScrollPane = new ScrollPane(this.entries, this.getSkin(), "default-vertical");
        this.entryScrollPane.setFadeScrollBars(false);
        this.entryScrollPane.pack();
        this.outerEntryTable = new Table();
        this.outerEntryTable.add(this.entryScrollPane).height(300.0f).top().left();
        this.outerEntryTable.pack();
        this.textScrollPane = new ScrollPane((Actor)this.textArea, this.getSkin(), "default-vertical");
        this.textScrollPane.setFadeScrollBars(false);
        this.textScrollPane.pack();
        this.outerTextTable = new Table();
        this.outerTextTable.add(this.textScrollPane).height(300.0f).width(200.0f).top();
        this.outerTextTable.pack();
    }

    public void setDisplayHeight(int entryHeight, int entryWidth, int textAreaHeight, int textAreaWidth) {
        this.outerEntryTable.getCell(this.entryScrollPane).size(entryWidth, entryHeight);
        this.outerEntryTable.pack();
        this.outerTextTable.getCell(this.textScrollPane).size(textAreaWidth, textAreaHeight);
        this.outerTextTable.pack();
        this.pack();
    }

    public void setPreferredRows(int rows) {
        this.textArea.setPrefRows(rows);
        this.pack();
    }

    public void setEntries(WikiEntry[] entries) {
        this.entries.setItems((WikiEntry[])entries);
    }

    private void onSelectedChanged() {
        if (this.entries.getSelected() != null) {
            this.textArea.setText(this.entries.getSelected().entryDescription);
        } else {
            this.textArea.setText("");
        }
    }

    @Override
    public void construct() {
        super.construct();
        this.add(this.outerEntryTable).padRight(10.0f).top();
        this.add(this.outerTextTable).top().fill();
        this.pack();
    }

    public static class WikiEntry {
        public String entryText;
        public String entryDescription;

        public WikiEntry(String entryText, String entryDescription) {
            this.entryText = entryText;
            this.entryDescription = entryDescription;
        }

        public String toString() {
            return this.entryText;
        }
    }
}

