/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.util.animation.Tweening;

public class Alert
extends IconLabel {
    public Alert(ComponentFactory componentFactory, String style) {
        super(componentFactory, style, "");
        this.setLabelAlign(8);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                Alert.this.hide();
            }
        });
    }

    public Alert(ComponentFactory componentFactory, IconLabel.IconLabelStyle style) {
        super(componentFactory);
        this.setStyle(style);
        this.setLabelAlign(8);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                Alert.this.hide();
            }
        });
    }

    public void show(float shopDuration) {
        this.addAction(Tweening.getGrowlAnimation(shopDuration));
    }

    public void hide() {
        this.clearActions();
        this.addAction(Actions.sequence((Action)Actions.alpha(0.0f, 0.4f), (Action)Actions.touchable(Touchable.disabled), (Action)Actions.hide()));
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
    }
}

