/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.Separator;
import com.neutronio.astrax.ui.commons.widgets.Alert;

public class AlertStack
extends Table {
    protected ComponentFactory componentFactory;
    private AlertStackStyle style;
    private Alert[] alerts;
    private float showDuration = 5.0f;

    public AlertStack(ComponentFactory componentFactory, int size) {
        this(componentFactory, "compact", size);
    }

    public AlertStack(ComponentFactory componentFactory, String style, int size) {
        super(componentFactory.getSkin());
        this.componentFactory = componentFactory;
        this.style = componentFactory.getSkin().get(style, AlertStackStyle.class);
        Separator separator = new Separator(componentFactory.getSkin(), "background_para");
        separator.setTouchable(Touchable.disabled);
        this.add().width(400.0f).height(1.0f).row();
        this.alerts = new Alert[size];
        for (int i2 = 0; i2 < this.alerts.length; ++i2) {
            this.alerts[i2] = new Alert(componentFactory, this.style.infoIconLabelStyle);
            this.alerts[i2].setVisible(false);
            switch (this.style.align) {
                case "center": {
                    this.add(this.alerts[i2]).padBottom(2.0f).padTop(2.0f).minHeight(42.0f).minWidth(this.alerts[i2].getStyle().labelMinWidth).center().row();
                    break;
                }
                case "left": {
                    this.add(this.alerts[i2]).padBottom(2.0f).padTop(2.0f).minHeight(42.0f).minWidth(this.alerts[i2].getStyle().labelMinWidth).left().row();
                    break;
                }
                case "right": {
                    this.add(this.alerts[i2]).padBottom(2.0f).padTop(2.0f).minHeight(42.0f).minWidth(this.alerts[i2].getStyle().labelMinWidth).right().row();
                }
            }
            this.alerts[i2].addAction(Actions.alpha(0.0f, 0.001f));
        }
        this.pack();
    }

    public void setStyle(AlertStackStyle style) {
        this.style = style;
        for (Alert alert : this.alerts) {
            alert.setStyle(style.infoIconLabelStyle);
        }
    }

    public void showMessage(Message message) {
        switch (message.getType()) {
            case SUCCESS: {
                this.showSuccessGrowl(this.componentFactory.translateMarked(message.getMessage()));
                break;
            }
            case INFO: {
                this.showInfoGrowl(this.componentFactory.translateMarked(message.getMessage()));
                break;
            }
            case WARNING: {
                this.showWarningGrowl(this.componentFactory.translateMarked(message.getMessage()));
                break;
            }
            case ALERT: {
                this.showErrorGrowl(this.componentFactory.translateMarked(message.getMessage()));
                break;
            }
            case EXCEPTION: {
                this.showErrorGrowl(this.componentFactory.translateMarked(message.getMessage()));
            }
        }
    }

    public void setShowDuration(float showDuration) {
        this.showDuration = showDuration;
    }

    private Alert getNextGrowl() {
        for (Alert alert : this.alerts) {
            if (alert.getColor().a != 0.0f || alert.hasActions()) continue;
            return alert;
        }
        return null;
    }

    public void showInfoGrowl(String text) {
        Alert alert = this.getNextGrowl();
        if (alert != null) {
            alert.setStyle(this.style.infoIconLabelStyle);
            alert.setBackgroundStyle(this.componentFactory.getSkin().get("info", Background.BackgroundStyle.class));
            alert.setText(text);
            alert.show(this.showDuration);
            this.pack();
        }
    }

    public void showSuccessGrowl(String text) {
        Alert alert = this.getNextGrowl();
        if (alert != null) {
            alert.setStyle(this.style.successIconLabelStyle);
            alert.setBackgroundStyle(this.componentFactory.getSkin().get("success", Background.BackgroundStyle.class));
            alert.setText(text);
            alert.squishIcon();
            alert.show(this.showDuration);
            this.pack();
        }
    }

    public void showWarningGrowl(String text) {
        Alert alert = this.getNextGrowl();
        if (alert != null) {
            alert.setStyle(this.style.warningIconLabelStyle);
            alert.setBackgroundStyle(this.componentFactory.getSkin().get("warning", Background.BackgroundStyle.class));
            alert.setText(text);
            alert.squishIcon();
            alert.show(this.showDuration);
            this.pack();
        }
    }

    public void showErrorGrowl(String text) {
        Alert alert = this.getNextGrowl();
        if (alert != null) {
            alert.setStyle(this.style.errorIconLabelStyle);
            alert.setBackgroundStyle(this.componentFactory.getSkin().get("error", Background.BackgroundStyle.class));
            alert.setText(text);
            alert.squishIcon();
            alert.show(this.showDuration);
            this.pack();
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    public static class AlertStackStyle {
        public IconLabel.IconLabelStyle baseIconLabelStyle;
        public Drawable background;
        public IconLabel.IconLabelStyle successIconLabelStyle;
        public IconLabel.IconLabelStyle infoIconLabelStyle;
        public IconLabel.IconLabelStyle warningIconLabelStyle;
        public IconLabel.IconLabelStyle errorIconLabelStyle;
        public String align;
    }
}

