/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;

public class AstraXSlider
extends WidgetGroup {
    public static final float MIN = 0.0f;
    public static final float MAX = 1.0f;
    private ComponentFactory componentFactory;
    private float value;
    private float targetValue;
    protected Background background;
    protected Background sliderKnob;
    protected AstraXSliderStyle style;

    public AstraXSlider(ComponentFactory componentFactory, String style) {
        this.componentFactory = componentFactory;
        this.background = new Background(componentFactory.getSkin());
        this.sliderKnob = new Background(componentFactory.getSkin());
        this.setStyle(componentFactory.getSkin().get(style, AstraXSliderStyle.class));
        this.addListener(new DragListener(){

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                super.drag(event, x, y, pointer);
                AstraXSlider.this.value = (this.getDragX() - AstraXSlider.this.sliderKnob.getDrawable().getMinWidth() / 2.0f) / AstraXSlider.this.getWidth();
                AstraXSlider.this.targetValue = AstraXSlider.this.value;
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer) {
                super.dragStop(event, x, y, pointer);
                AstraXSlider.this.value = (this.getDragX() - AstraXSlider.this.sliderKnob.getDrawable().getMinWidth() / 2.0f) / AstraXSlider.this.getWidth();
                AstraXSlider.this.targetValue = AstraXSlider.this.value;
                ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                AstraXSlider.this.fire(changeEvent);
                Pools.free(changeEvent);
            }
        });
        this.addListener(new ClickListener(){

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                super.touchUp(event, x, y, pointer, button);
                if (x > 0.0f) {
                    AstraXSlider.this.targetValue = (x - AstraXSlider.this.sliderKnob.getDrawable().getMinWidth() / 2.0f) / AstraXSlider.this.getWidth();
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    AstraXSlider.this.fire(changeEvent);
                    Pools.free(changeEvent);
                }
            }
        });
        this.addActor(this.background);
        this.addActor(this.sliderKnob);
    }

    public AstraXSlider(ComponentFactory componentFactory) {
        this(componentFactory, "default");
    }

    public void setStyle(AstraXSliderStyle style) {
        this.style = style;
        this.background.setStyle(style.backgroundStyle);
        this.sliderKnob.setStyle(style.knobStyle);
        this.sliderKnob.setSize(this.sliderKnob.getDrawable().getMinWidth(), this.sliderKnob.getDrawable().getMinHeight());
    }

    public float getValue() {
        return this.value;
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    public void setValue(float value) {
        this.targetValue = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.value = this.value * 0.9f + this.targetValue * 0.1f;
        int knobPosition = (int)MathUtils.clamp(this.getWidth() * this.value, -this.sliderKnob.getDrawable().getMinWidth() / 2.0f, this.getWidth() - this.sliderKnob.getDrawable().getMinWidth());
        this.sliderKnob.setPosition(knobPosition, this.getHeight() / 2.0f - this.sliderKnob.getDrawable().getMinHeight() / 2.0f);
        this.background.setSize(this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }

    @Override
    public float getPrefWidth() {
        return 180.0f;
    }

    @Override
    public float getPrefHeight() {
        return 20.0f;
    }

    public static class AstraXSliderStyle {
        Background.BackgroundStyle backgroundStyle;
        Background.BackgroundStyle knobStyle;
    }
}

