/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;

public class Avatar
extends Table {
    private ComponentFactory factory;
    private Actor avatar;
    private Background background;

    public Avatar(ComponentFactory componentFactory) {
        this.factory = componentFactory;
        this.background = new Background(componentFactory.getSkin());
    }

    public void setAvatar(Actor actor, int width, int height) {
        this.clearChildren();
        this.avatar = actor;
        this.avatar.setTouchable(Touchable.disabled);
        this.add(this.avatar).size(width, height);
        this.pack();
    }

    @Override
    public void setBackground(String backgroundStyle) {
        this.background.setStyle(this.factory.getSkin().get(backgroundStyle, Background.BackgroundStyle.class));
        this.pad(this.background.getStyle().padding);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.background != null) {
            this.background.setColor(this.background.getCurrentColor().r, this.background.getCurrentColor().g, this.background.getCurrentColor().b, this.background.getCurrentColor().a * parentAlpha);
            this.background.setSize(this.getWidth(), this.getHeight());
            this.background.setPosition(this.getX(), this.getY());
            this.background.draw(batch, parentAlpha);
        }
        super.draw(batch, parentAlpha);
    }
}

