/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.Paginator;

public class BubblePaginator
extends HorizontalGroup {
    private ComponentFactory factory;
    private Paginator paginator;
    private ButtonGroup<AstraXButton> buttonGroup;

    public BubblePaginator(ComponentFactory componentFactory) {
        this.space(10.0f);
        this.factory = componentFactory;
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.setMaxCheckCount(1);
        this.buttonGroup.setMinCheckCount(1);
        this.buttonGroup.setUncheckLast(true);
    }

    public void setPaginator(Paginator defaultPaginator) {
        this.clearChildren();
        this.buttonGroup.clear();
        this.paginator = defaultPaginator;
        for (int i2 = 0; i2 < this.paginator.getMaxPages(); ++i2) {
            AstraXButton button = new AstraXButton(this.factory, "bubblePaginatorButton");
            button.setCanCheck(true);
            button.setUserObject(i2);
            button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (actor.getUserObject() instanceof Integer) {
                        int buttonIndex = (Integer)actor.getUserObject();
                        BubblePaginator.this.getPaginator().setCurrentPage(buttonIndex + 1);
                    }
                }
            });
            button.addListener(this.factory.getToolTip("Page " + (i2 + 1)));
            this.addActor(button);
            this.buttonGroup.add(button);
            if (i2 != defaultPaginator.getCurrentPage() - 1) continue;
            button.setChecked(true);
        }
    }

    private Paginator getPaginator() {
        return this.paginator;
    }

    public void update() {
        this.buttonGroup.setChecked(this.paginator.getCurrentPage() - 1);
    }

    public void updateChange() {
        this.setPaginator(this.paginator);
    }
}

