/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class ColorIconArray
extends SimplePanel {
    protected ComponentFactory factory;
    protected String soundSelect = "zoom:in";
    protected String colorSwatchDrawable = "background_rect_icon";
    protected String overDrawable = "background_rect_frame";
    protected Image[] icons;
    protected int iconsPerRow = 4;
    protected Image overIcon;
    protected Image selectedIcon;
    private ColorIconArrayListener listener;

    public ColorIconArray(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, "buttons", backgroundStyle);
        this.pad(7.0f);
        this.factory = componentFactory;
        this.overIcon = new Image(this.factory.getSkin(), this.overDrawable);
        this.overIcon.setTouchable(Touchable.disabled);
        this.overIcon.setOrigin(1);
        this.overIcon.setColor(this.factory.getSkin().getColor("primary"));
        this.addActor(this.overIcon);
    }

    public void setIconsPerRow(int iconPerRow) {
        this.iconsPerRow = iconPerRow;
    }

    public void setColorPalette(Color ... colors) {
        this.icons = new Image[colors.length];
        for (int i2 = 0; i2 < this.icons.length; ++i2) {
            this.icons[i2] = new Image(this.factory.getSkin(), this.colorSwatchDrawable);
            this.icons[i2].setUserObject(i2);
            this.icons[i2].setColor(colors[i2]);
            this.icons[i2].addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (!ColorIconArray.this.hasActions()) {
                        Image selectedImage = (Image)event.getTarget();
                        ColorIconArray.this.moveOverIconToSelectedIcon(selectedImage);
                        if (ColorIconArray.this.getListener() != null) {
                            ColorIconArray.this.getListener().onColorSelected((Integer)selectedImage.getUserObject(), selectedImage.getColor());
                        }
                        ColorIconArray.this.factory.playUISound(ColorIconArray.this.soundSelect);
                    }
                }
            });
            this.addValueCentered(this.icons[i2]).pad(1.0f);
            if ((i2 + 1) % this.iconsPerRow != 0) continue;
            this.row();
        }
        this.pack();
        this.moveOverIconToSelectedIcon(this.icons[0]);
    }

    public void selectColor(int index) {
        if (index < 0) {
            this.hideOverIcon();
        } else {
            this.moveOverIconToSelectedIcon(this.icons[index]);
        }
    }

    public int getSelectedIndex() {
        if (this.selectedIcon == null) {
            return -1;
        }
        return (Integer)this.selectedIcon.getUserObject();
    }

    public Color getSelectedColor() {
        return this.selectedIcon.getColor();
    }

    public void setListener(ColorIconArrayListener listener) {
        this.listener = listener;
    }

    private ColorIconArrayListener getListener() {
        return this.listener;
    }

    private void hideOverIcon() {
        this.selectedIcon = null;
        this.overIcon.addAction(Actions.fadeOut(0.1f));
    }

    private void moveOverIconToSelectedIcon(Image icon) {
        this.selectedIcon = icon;
        this.overIcon.addAction(Actions.alpha(1.0f));
        this.overIcon.addAction(Actions.moveTo(icon.getX() + icon.getWidth() / 2.0f - this.overIcon.getWidth() / 2.0f, icon.getY() + icon.getHeight() / 2.0f - this.overIcon.getHeight() / 2.0f, 0.2f, Interpolation.pow2In));
        this.overIcon.addAction(Actions.sequence((Action)Actions.scaleBy(1.1f, 1.1f, 0.1f), (Action)Actions.scaleBy(-1.1f, -1.1f, 0.3f)));
    }

    public static interface ColorIconArrayListener {
        public void onColorSelected(int var1, Color var2);
    }
}

