/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ColorPalette;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.BubblePaginator;
import com.neutronio.astrax.ui.commons.widgets.RGBSlider;
import java.util.Map;

public class ColorPaletteEditor
extends SimplePanel {
    private ColorPalette colorPalette;
    private BubblePaginator paginator;
    private RGBSlider RGBSlider;

    public ColorPaletteEditor(ComponentFactory componentFactory) {
        super(componentFactory);
        this.colorPalette = new ColorPalette(componentFactory);
        this.colorPalette.fillWithButtons("color");
        this.colorPalette.updateToContent();
        this.colorPalette.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color color = null;
                if (ColorPaletteEditor.this.colorPalette.getSelected() != null) {
                    color = ((Color)ColorPaletteEditor.this.colorPalette.getSelected()).cpy();
                    ColorPaletteEditor.this.RGBSlider.setPickedColor(color);
                }
            }
        });
        this.paginator = new BubblePaginator(componentFactory);
        this.paginator.setPaginator(this.colorPalette);
        this.paginator.align(1);
        this.RGBSlider = new RGBSlider(componentFactory);
        this.RGBSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                Color selected = (Color)ColorPaletteEditor.this.colorPalette.getSelected();
                if (selected != null) {
                    Color newColor = ColorPaletteEditor.this.RGBSlider.getPickedColor();
                    selected.r = newColor.r;
                    selected.g = newColor.g;
                    selected.b = newColor.b;
                    ColorPaletteEditor.this.colorPalette.updateButtonStyle(ColorPaletteEditor.this.colorPalette.getSelectedButton(), selected);
                }
            }
        });
        SimplePanel table = new SimplePanel(componentFactory);
        table.addValue(this.colorPalette);
        table.row();
        table.addValue(this.paginator).center();
        this.addValue(table);
        this.addValue(this.RGBSlider);
    }

    public void setColorPalette(Map<String, Color> palette) {
        for (Color color : palette.values()) {
            this.colorPalette.addItem(color);
        }
        this.colorPalette.updateToContent();
        this.paginator.updateChange();
    }

    public Color getSelectedColor() {
        return (Color)this.colorPalette.getSelected();
    }
}

