/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.ColorIconArray;

public class ColorSelectBox
extends Group
implements ColorIconArray.ColorIconArrayListener {
    private ComponentFactory factory;
    private ColorIconArray colorIconArray;
    private Button selectedIcon;
    protected String colorSwatchDrawable = "background_rect_icon";
    protected String soundExpand = "expand";
    protected String soundRetract = "retract";

    public ColorSelectBox(ComponentFactory componentFactory) {
        this.factory = componentFactory;
        this.colorIconArray = new ColorIconArray(componentFactory, "inset");
        this.colorIconArray.setVisible(false);
        this.colorIconArray.setListener(this);
        this.selectedIcon = new Button(this.factory.getSkin().getDrawable(this.colorSwatchDrawable));
        this.selectedIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (ColorSelectBox.this.colorIconArray.isVisible()) {
                    ColorSelectBox.this.hideColorIcons(0.0f);
                } else {
                    ColorSelectBox.this.showColorIcons();
                }
            }
        });
        this.addActor(this.selectedIcon);
        this.addActor(this.colorIconArray);
        this.colorIconArray.setPosition(this.selectedIcon.getWidth() / 2.0f, this.selectedIcon.getHeight() / 2.0f);
        this.setSize(this.selectedIcon.getMinWidth(), this.selectedIcon.getMinHeight());
    }

    public void setColors(Color ... colors) {
        this.colorIconArray.setColorPalette(colors);
    }

    @Override
    public void onColorSelected(int index, Color color) {
        this.selectedIcon.setColor(color);
        this.hideColorIcons(0.2f);
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    public int getSelectedIndex() {
        return this.colorIconArray.getSelectedIndex();
    }

    public void setSelectedColor(int index) {
        this.colorIconArray.selectColor(index);
        if (index < 0) {
            this.selectedIcon.setColor(Color.GRAY);
        } else {
            this.selectedIcon.setColor(this.colorIconArray.icons[index].getColor());
        }
    }

    private void showColorIcons() {
        this.colorIconArray.addAction(Actions.sequence((Action)Actions.show(), (Action)Actions.fadeIn(0.2f)));
        this.factory.playUISound(this.soundExpand);
    }

    private void hideColorIcons(float delay) {
        this.colorIconArray.addAction(Actions.sequence((Action)Actions.delay(delay), (Action)Actions.fadeOut(0.5f), (Action)Actions.hide()));
        this.factory.playUISound(this.soundRetract);
    }
}

