/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ColorSwatches
extends SimplePanel {
    protected ImageComparator imageComparator = new ImageComparator();
    protected List<Image> icons = new ArrayList<Image>();
    protected int iconsPerRow = 4;
    protected String colorSwatchDrawable = "background_rect_icon";

    public ColorSwatches(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public void setIconsPerRow(int iconsPerRow) {
        this.iconsPerRow = iconsPerRow;
    }

    public void setColorPalette(Color ... colors) {
        this.icons.clear();
        this.clearChildren();
        for (int i2 = 0; i2 < this.icons.size(); ++i2) {
            Image image = new Image(this.componentFactory.getSkin(), this.colorSwatchDrawable);
            image.setColor(colors[i2]);
            image.setName(i2 + "");
            this.icons.add(image);
            this.addValueCentered(image).pad(1.0f);
            if ((i2 + 1) % this.iconsPerRow != 0) continue;
            this.row();
        }
        this.pack();
    }

    public void setColorPalette(Map<String, Color> palette) {
        this.icons.clear();
        this.clearChildren();
        for (String key : palette.keySet()) {
            Image image = new Image(this.componentFactory.getSkin(), this.colorSwatchDrawable);
            image.setColor(palette.get(key));
            image.setName(key);
            this.icons.add(image);
        }
        Collections.sort(this.icons, this.imageComparator);
        int i2 = 0;
        for (Image image : this.icons) {
            this.addValueCentered(image).pad(1.0f);
            if ((i2 + 1) % this.iconsPerRow == 0) {
                this.row();
            }
            ++i2;
        }
        this.pack();
    }

    private class ImageComparator
    implements Comparator<Image> {
        private ImageComparator() {
        }

        @Override
        public int compare(Image o1, Image o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

