/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.ui.commons.widgets.Paginator;

public class DefaultPaginator
implements Paginator {
    private int currentPage = 1;
    private int maxPages = 1;

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = MathUtils.clamp(currentPage, 1, this.maxPages);
    }

    @Override
    public int getMaxPages() {
        return this.maxPages;
    }

    @Override
    public void setMaxPages(int maxPages) {
        this.maxPages = Math.abs(maxPages);
        this.currentPage = MathUtils.clamp(this.currentPage, 1, this.maxPages);
    }

    @Override
    public void configure(int totalItems, int itemsPerPage) {
        this.maxPages = totalItems == 0 ? 1 : Math.abs(itemsPerPage > 0 ? (int)Math.ceil((float)totalItems / (float)itemsPerPage) : 1);
        this.currentPage = MathUtils.clamp(this.currentPage, 1, this.maxPages);
    }

    @Override
    public void nextPage() {
        this.currentPage = MathUtils.clamp(this.currentPage + 1, 1, this.maxPages);
    }

    @Override
    public void previousPage() {
        this.currentPage = MathUtils.clamp(this.currentPage - 1, 1, this.maxPages);
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }
}

