/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DressupLayer;
import com.neutronio.astrax.app.DressupSettings;
import com.neutronio.astrax.app.repository.DressupSettingsRepository;
import com.neutronio.astrax.gfx.factories.AvatarFactory;
import com.neutronio.astrax.ui.AstraXSkin;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.commons.widgets.ColorSelectBox;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class DressupAvatarPanel
extends SimplePanel {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private AvatarFactory avatarFactory;
    private ComponentFactory componentFactory;
    private List<DressupAvatarControl> controls;
    private AstraXTextButton randomizerIcon;
    private DressupSettings settings;
    private Integer[] textureIndices = new Integer[]{0, 0, 0, 0, 0, null};
    private Integer[] colorIndices = new Integer[]{0, 0, 0, 0, 0, null};
    private Group group;

    public DressupAvatarPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.avatarFactory = new AvatarFactory();
        this.avatarFactory.setSkin((AstraXSkin)this.componentFactory.getSkin());
        this.randomizerIcon = new AstraXTextButton(componentFactory, "primary");
        this.randomizerIcon.setText("Randomize");
        this.randomizerIcon.setCanCheck(false);
        this.randomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                DressupAvatarPanel.this.randomize();
                DressupAvatarPanel.this.updateAvatar();
            }
        });
        this.group = new Group();
        this.group.setTouchable(Touchable.disabled);
        this.group.setScale(5.0f);
        this.group.setSize(150.0f, 175.0f);
        DressupSettingsRepository repository = AstraXApp.astraX.getRepository(DressupSettingsRepository.class);
        this.settings = (DressupSettings)repository.find("avatar_human");
        SimplePanel controlPanel = new SimplePanel(componentFactory);
        this.controls = new ArrayList<DressupAvatarControl>();
        int layerIndex = 0;
        for (DressupLayer layer : this.settings.layers) {
            DressupAvatarControl controller = new DressupAvatarControl(layerIndex);
            controller.colorSelectBox = new ColorSelectBox(componentFactory);
            controller.colorSelectBox.setColors(layer.availableColors.toArray(new Color[1]));
            controller.colorSelectBox.setSelectedColor(0);
            controller.colorSelectBox.addListener(controller);
            controller.selector = new TextSelector(componentFactory);
            int i2 = 0;
            if (layer.allowNone) {
                controller.selector.addItem(new SelectBoxWrapper<Object>("None", null));
            }
            for (DressupLayer.TextureSettings textureSettings : layer.definitions) {
                controller.selector.addItem(new SelectBoxWrapper<Integer>(textureSettings.displayName, i2));
                ++i2;
            }
            controller.selector.addListener(controller);
            this.controls.add(controller);
            controlPanel.addLabel(layer.displayName);
            controlPanel.addValue(controller.selector).padRight(15.0f);
            controlPanel.addValue(controller.colorSelectBox).size(28.0f, 28.0f).center().row();
            ++layerIndex;
        }
        controlPanel.pack();
        Table avatarGroup = new Table();
        avatarGroup.add(this.group).top().row();
        avatarGroup.add(this.randomizerIcon).padTop(20.0f);
        this.addValue(avatarGroup);
        this.addValue(controlPanel);
        this.pack();
        this.updateTextSelectors();
    }

    public Integer[] getTextureIndices() {
        return this.textureIndices;
    }

    public Integer[] getColorIndices() {
        return this.colorIndices;
    }

    public void setIndices(Integer[] textureIndices, Integer[] colorIndices) {
        this.textureIndices = Arrays.copyOf(textureIndices, textureIndices.length);
        this.colorIndices = Arrays.copyOf(colorIndices, colorIndices.length);
        this.updateTextSelectors();
    }

    private void updateTextSelectors() {
        for (int i2 = 0; i2 < this.controls.size(); ++i2) {
            this.controls.get((int)i2).selector.setSelected(this.textureIndices[i2], false);
            this.controls.get((int)i2).colorSelectBox.setSelectedColor(this.colorIndices[i2] == null ? -1 : this.colorIndices[i2]);
        }
    }

    public void randomize() {
        int layerIndex = 0;
        for (DressupLayer layer : this.settings.layers) {
            int random = MathUtil.getRandomInteger(2);
            if (layer.allowNone && random == 0) {
                this.textureIndices[layerIndex] = null;
                this.colorIndices[layerIndex] = null;
            } else {
                this.textureIndices[layerIndex] = MathUtil.getRandomInteger(layer.definitions.size());
                this.colorIndices[layerIndex] = MathUtil.getRandomInteger(layer.availableColors.size());
            }
            ++layerIndex;
        }
        this.updateTextSelectors();
    }

    public void updateAvatar() {
        List<Image> images = this.avatarFactory.create(this.textureIndices, this.colorIndices, this.settings);
        this.group.clear();
        for (Image image : images) {
            this.group.addActor(image);
        }
    }

    public class DressupAvatarControl
    extends ChangeListener {
        int layer = -1;
        TextSelector<Integer> selector;
        ColorSelectBox colorSelectBox;

        public DressupAvatarControl(int layer) {
            this.layer = layer;
        }

        public void updateIndices() {
            int selectedColorIndex = this.colorSelectBox.getSelectedIndex();
            ((DressupAvatarPanel)DressupAvatarPanel.this).textureIndices[this.layer] = this.selector.getSelectedObject();
            ((DressupAvatarPanel)DressupAvatarPanel.this).colorIndices[this.layer] = selectedColorIndex < 0 ? 0 : selectedColorIndex;
            DressupAvatarPanel.this.logger.finest("Selected texture index: " + this.selector.getSelectedObject());
            DressupAvatarPanel.this.logger.finest("Selected color index: " + selectedColorIndex);
        }

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            this.updateIndices();
            DressupAvatarPanel.this.updateAvatar();
        }
    }
}

