/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DynamicInfoComponent
extends AstraXComponent {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Map<Class, Table> detailComponents = new HashMap<Class, Table>();
    private Stack detailComponentStack = new Stack();
    private StackController detailComponentController;

    public DynamicInfoComponent(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public Stack getDetailComponentStack() {
        return this.detailComponentStack;
    }

    public void putDetailComponent(Table detailComponent, Class forClass) {
        if (forClass == null) {
            return;
        }
        this.detailComponents.put(forClass, detailComponent);
        this.detailComponentStack.add(detailComponent);
    }

    public void initStackController() {
        this.detailComponentStack.pack();
        this.detailComponentController = new StackController(this.detailComponentStack);
    }

    public Table getDetailComponent(Class clazz) {
        return this.detailComponents.get(clazz);
    }

    public void showDetailComponentFor(Class clazz) {
        if (clazz == null) {
            this.detailComponentController.hide();
            return;
        }
        Table detailComponent = this.detailComponents.get(clazz);
        if (detailComponent != null) {
            this.detailComponentController.show(detailComponent);
        } else {
            this.logger.warning("No Detail Component available for class " + clazz);
        }
    }
}

