/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.Background;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;

public class Header
extends AstraXComponent {
    protected StaticIcon headerIcon;
    protected AstraXButton exitButton;
    protected AstraXButton helpButton;
    protected Label headerText;
    protected Background background;

    public Header(ComponentFactory factory) {
        super(factory, "window-header");
        this.align(1);
        this.headerIcon = new StaticIcon(factory.getSkin(), "header");
        this.headerIcon.setInlineIcon((Drawable)null);
        this.headerText = new Label("Header", this.componentFactory.getSkin(), "header-no-bg");
        this.exitButton = new AstraXButton(this.componentFactory, "icon_inline_x", "primary-no-check");
        this.exitButton.setCanCheck(false);
        this.helpButton = new AstraXButton(this.componentFactory, "icon_inline_questionmark", "primary-no-check");
        this.helpButton.setCanCheck(false);
    }

    public void setHeaderIcon(String inlineIcon) {
        this.headerIcon.setInlineIcon(inlineIcon);
    }

    public AstraXButton getExitButton() {
        return this.exitButton;
    }

    public AstraXButton getHelpButton() {
        return this.helpButton;
    }

    public void setTitle(String text) {
        this.headerText.setText(text);
    }

    @Override
    public void construct() {
        super.construct();
        this.add(this.headerIcon).padRight(5.0f);
        this.add(this.headerText).padLeft(5.0f).padTop(2.0f).left().expand();
        this.add(this.helpButton).padRight(2.0f).padTop(5.0f).right().top();
        this.add(this.exitButton).padRight(5.0f).padTop(5.0f).right().top();
        this.pack();
    }
}

