/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;

public class IconPicker
extends Group {
    protected ComponentFactory factory;
    protected String soundSelect = "zoom:in";
    protected Table iconBody;
    protected int iconsPerRow = 4;
    protected Skin skin;
    protected Image[] icons;
    protected Image overIcon;
    protected Image selectedIcon;
    protected IconPickerListener iconPickerListener;

    public IconPicker(ComponentFactory factory) {
        this.factory = factory;
        this.skin = factory.getSkin();
        this.overIcon = new Image(this.skin, "icon_round_over");
        this.overIcon.setOrigin(1);
        this.overIcon.setColor(this.skin.getColor("primary"));
        this.iconBody = new Table(this.skin);
        this.addActor(this.iconBody);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (IconPicker.this.iconPickerListener != null) {
                    IconPicker.this.iconPickerListener.onIconClicked(IconPicker.this.selectedIcon);
                }
            }
        });
    }

    public void setIconColor(Color color) {
        for (Image icon : this.icons) {
            icon.setColor(color);
        }
    }

    public void setIconsPerRow(int iconPerRow) {
        this.iconsPerRow = iconPerRow;
    }

    public void setIcons(String ... drawables) {
        if (drawables.length <= 0) {
            return;
        }
        this.iconBody.clear();
        this.icons = new Image[drawables.length];
        int i2 = 0;
        for (String drawable : drawables) {
            this.icons[i2] = new Image(this.skin, drawable);
            this.icons[i2].setName(drawable);
            this.icons[i2].addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (!IconPicker.this.hasActions()) {
                        IconPicker.this.setSelectedIcon((Image)event.getTarget());
                        IconPicker.this.factory.playUISound(IconPicker.this.soundSelect);
                    }
                }
            });
            this.iconBody.add(this.icons[i2]).pad(2.0f);
            if ((i2 + 1) % this.iconsPerRow == 0) {
                this.iconBody.row();
            }
            ++i2;
        }
        this.iconBody.pack();
        this.setSize(this.iconBody.getWidth(), this.iconBody.getHeight());
        this.selectedIcon = this.icons[0];
        this.addActor(this.overIcon);
    }

    public void setSelectedIcon(String name) {
        for (Image icon : this.icons) {
            if (!icon.getName().contains(name)) continue;
            this.setSelectedIcon(icon);
            return;
        }
        this.setSelectedIcon(new Image(this.skin.getDrawable("icon_inline_cog")));
    }

    public void setSelectedIcon(Image icon) {
        this.selectedIcon = icon;
        this.overIcon.addAction(Actions.moveTo(this.selectedIcon.getX() + this.selectedIcon.getWidth() / 2.0f - this.overIcon.getWidth() / 2.0f, this.selectedIcon.getY() + this.selectedIcon.getHeight() / 2.0f - this.overIcon.getHeight() / 2.0f, 0.2f, Interpolation.pow2In));
        this.overIcon.addAction(Actions.sequence((Action)Actions.rotateBy(90.0f, 0.1f), (Action)Actions.rotateBy(-90.0f, 0.3f)));
    }

    public IconPickerListener getIconPickerListener() {
        return this.iconPickerListener;
    }

    public void setIconPickerListener(IconPickerListener iconPickerListener) {
        this.iconPickerListener = iconPickerListener;
    }

    public Drawable getSelectedDrawable() {
        return this.selectedIcon.getDrawable();
    }

    public String getSelectedDrawableName() {
        return this.selectedIcon.getName();
    }

    public static interface IconPickerListener {
        public void onIconClicked(Image var1);
    }
}

