/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Scrollbar;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListComponent<E>
extends AbstractPanel {
    private ComponentFactory componentFactory;
    private int rows = -1;
    private List<SelectBoxWrapper<E>> elements = new ArrayList<SelectBoxWrapper<E>>();
    private List<Row> elementRows = new ArrayList<Row>();
    private Row selectedRow;
    private SimplePanel content;
    private Scrollbar scrollbar;

    public ListComponent(ComponentFactory componentFactory, int rows) {
        super(componentFactory, "list");
        this.rows = rows;
        this.pad(10.0f);
        this.scrollbar = new Scrollbar(componentFactory, "default");
        this.scrollbar.setDirection(0, 1);
        this.scrollbar.setOffset(0);
        this.scrollbar.setMax(0);
        this.scrollbar.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                ListComponent.this.updateToContent();
            }
        });
        this.componentFactory = componentFactory;
        this.content = new SimplePanel(componentFactory, "list", null);
        for (int i2 = 0; i2 < this.rows; ++i2) {
            AstraXLabel label = this.content.addLabel("", "file-large");
            this.content.getCell(label).minHeight(32.0f).expand();
            Row row = new Row(label);
            this.content.row();
            this.elementRows.add(row);
        }
        this.content.align(1);
        this.content.pack();
        this.scrollbar.setSize(28.0f, this.content.getHeight());
        super.construct();
        this.add(this.content).expandY().fill();
        this.add(this.scrollbar).top().expandY().fill().minWidth(28.0f).maxWidth(28.0f);
        this.pack();
    }

    public ListComponent(ComponentFactory componentFactory) {
        this(componentFactory, 7);
    }

    public void setElements(List<SelectBoxWrapper<E>> elements) {
        this.deselectRow();
        this.scrollbar.setMax(elements.size() - 1);
        this.elements = elements;
        this.updateToContent();
        this.content.pack();
        this.scrollbar.setSize(28.0f, this.content.getHeight());
        this.scrollbar.pack();
    }

    private void updateToContent() {
        for (int i2 = 0; i2 < this.elementRows.size(); ++i2) {
            Row row = this.elementRows.get(i2);
            row.update("");
            row.nameLabel.setColor(this.componentFactory.getSkin().getColor("disabled"));
        }
        int startIndex = this.scrollbar.getOffset();
        int buttonIndex = 0;
        for (int i3 = startIndex; i3 < startIndex + this.elements.size() && i3 < this.elements.size() && buttonIndex < this.elementRows.size(); ++buttonIndex, ++i3) {
            SelectBoxWrapper<E> wrapper = this.elements.get(i3);
            Row row = this.elementRows.get(buttonIndex);
            row.element = wrapper.getPayload();
            row.update(wrapper.toString());
        }
        this.content.pack();
        if (this.selectedRow != null) {
            this.selectedRow.deselect();
        }
        this.content.pack();
        this.pack();
        this.scrollbar.setSize(28.0f, this.getHeight());
        this.scrollbar.pack();
    }

    public void deselectRow() {
        if (this.selectedRow != null) {
            this.selectedRow.deselect();
        }
        this.selectedRow = null;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    @Override
    public void resetValues() {
    }

    public void unmarkAll() {
        for (Row row : this.elementRows) {
            row.unmark();
        }
    }

    public void markElement(E element) {
        for (Row row : this.elementRows) {
            if (!Objects.equals(row.element, element)) continue;
            row.mark();
        }
    }

    public void unmarkElement(E element) {
        for (Row row : this.elementRows) {
            if (!Objects.equals(row.element, element)) continue;
            row.unmark();
        }
    }

    public E getSelectedElement() {
        return this.selectedRow != null ? (E)this.selectedRow.element : null;
    }

    private class Row {
        boolean isSelected = false;
        boolean marked = false;
        E element;
        AstraXLabel nameLabel;
        ClickListener clickListener;

        public Row(AstraXLabel name) {
            this.nameLabel = name;
            this.clickListener = new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (Row.this.element == null) {
                        return;
                    }
                    if (Row.this.isSelected) {
                        ListComponent.this.deselectRow();
                        ListComponent.this.componentFactory.playUISound("retract");
                    } else {
                        ListComponent.this.componentFactory.playUISound("expand");
                        Row.this.select();
                        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                        ListComponent.this.fire(changeEvent);
                        Pools.free(changeEvent);
                    }
                }
            };
            this.nameLabel.addListener(this.clickListener);
        }

        public void update(String name) {
            this.nameLabel.setText(name);
        }

        public void select() {
            if (ListComponent.this.selectedRow != null) {
                ListComponent.this.selectedRow.deselect();
            }
            this.isSelected = true;
            ListComponent.this.selectedRow = this;
            this.nameLabel.getBackground().setState(ReactiveColor.ReactiveState.CHECKED);
            if (this.marked) {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("tertiary-bright"));
            } else {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("white"));
            }
        }

        public void deselect() {
            this.isSelected = false;
            this.nameLabel.getBackground().setState(ReactiveColor.ReactiveState.UP);
            if (this.marked) {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("secondary-bright"));
            } else {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("disabled"));
            }
        }

        public void mark() {
            this.marked = true;
            if (this.isSelected) {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("tertiary-bright"));
            } else {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("secondary-bright"));
            }
        }

        public void unmark() {
            this.marked = false;
            if (this.isSelected) {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("white"));
            } else {
                this.nameLabel.setColor(ListComponent.this.componentFactory.getSkin().getColor("disabled"));
            }
        }
    }
}

