/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.neutronio.astrax.ui.commons.widgets.TextButtonTabs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class ListWithTooltips<T extends Button>
extends Table {
    private float columnCount = 1.0f;
    private ListWithTooltipsModel listModel;
    private TextButtonTabs.ButtonSettings buttonSettings;
    private List<T> buttons = new ArrayList<T>();

    public ListWithTooltips(Skin skin) {
        super(skin);
    }

    public float getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(float columns) {
        this.columnCount = columns;
    }

    public ListWithTooltipsModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListWithTooltipsModel listModel) {
        this.listModel = listModel;
        this.updateFromModel();
        this.construct();
    }

    public TextButtonTabs.ButtonSettings getButtonSettings() {
        return this.buttonSettings;
    }

    public void setButtonSettings(TextButtonTabs.ButtonSettings buttonSettings) {
        this.buttonSettings = buttonSettings;
    }

    public void construct() {
        this.clear();
        int counter = 1;
        for (Button button : this.buttons) {
            this.add(button).minSize(this.buttonSettings.minButtonWidth, this.buttonSettings.minButtonHeight).fill();
            if ((float)counter == this.columnCount) {
                this.row();
                counter = 1;
                continue;
            }
            ++counter;
        }
        this.pack();
    }

    public void updateFromModel() {
        for (Button button : this.buttons) {
            button.clearListeners();
        }
        this.buttons.clear();
        if (this.listModel != null) {
            for (Map.Entry entry : this.listModel.entries.entrySet()) {
                ToolTipModel toolTipModel = (ToolTipModel)entry.getValue();
                Button button = this.getButton(toolTipModel, this.buttonSettings);
                button.setDisabled(true);
                Tooltip<Table> tooltip = this.getTooltip(toolTipModel);
                button.addListener(tooltip);
                this.buttons.add(button);
            }
        }
    }

    private Tooltip<Table> getTooltip(ToolTipModel toolTipModel) {
        Table panel = new Table(this.getSkin());
        panel.setBackground("label_1");
        TextArea textArea = new TextArea(toolTipModel.toolTipText, this.getSkin());
        textArea.setDisabled(true);
        panel.add(new Image(this.getSkin(), "icon_info")).size(32.0f, 32.0f).pad(10.0f).top();
        int width = 320;
        int avgLetterWidth = 14;
        int avgLetterHeight = 15;
        int lines = toolTipModel.toolTipText.length() * avgLetterWidth / width;
        panel.add(textArea).minSize(width, lines * avgLetterHeight).pad(10.0f);
        Tooltip<Table> tableTooltip = new Tooltip<Table>(panel);
        return tableTooltip;
    }

    private Button getButton(ToolTipModel toolTipModel, TextButtonTabs.ButtonSettings buttonSettings) {
        Button.ButtonStyle buttonStyle = this.getSkin().get(buttonSettings.styleName, buttonSettings.styleClass);
        if (buttonStyle instanceof ImageTextButton.ImageTextButtonStyle) {
            ImageTextButton.ImageTextButtonStyle imageTextButtonStyle = (ImageTextButton.ImageTextButtonStyle)buttonStyle;
            ImageTextButton.ImageTextButtonStyle imageTextButtonStyleCopy = new ImageTextButton.ImageTextButtonStyle();
            imageTextButtonStyleCopy.up = imageTextButtonStyle.up;
            imageTextButtonStyleCopy.down = imageTextButtonStyle.down;
            imageTextButtonStyleCopy.checked = imageTextButtonStyle.checked;
            imageTextButtonStyleCopy.checkedOver = imageTextButtonStyle.checkedOver;
            imageTextButtonStyleCopy.checkedDown = imageTextButtonStyle.checkedDown;
            imageTextButtonStyleCopy.over = imageTextButtonStyle.up;
            imageTextButtonStyleCopy.font = imageTextButtonStyle.font;
            imageTextButtonStyleCopy.fontColor = imageTextButtonStyle.fontColor;
            imageTextButtonStyleCopy.overFontColor = imageTextButtonStyle.overFontColor;
            imageTextButtonStyleCopy.imageUp = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            imageTextButtonStyleCopy.imageDown = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            imageTextButtonStyleCopy.imageChecked = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            return new ImageTextButton(toolTipModel.buttonText, imageTextButtonStyleCopy);
        }
        if (buttonStyle instanceof TextButton.TextButtonStyle) {
            TextButton button = new TextButton(toolTipModel.buttonText, (TextButton.TextButtonStyle)buttonStyle);
            CharSequence text = button.getText();
            return button;
        }
        if (buttonStyle instanceof Button.ButtonStyle) {
            Button.ButtonStyle buttonStyleCopy = new Button.ButtonStyle();
            buttonStyleCopy.up = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            buttonStyleCopy.down = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            buttonStyleCopy.over = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            buttonStyleCopy.checked = this.getSkin().getDrawable(toolTipModel.buttonIcon);
            return new Button(buttonStyleCopy);
        }
        return null;
    }

    public static class ListWithTooltipsModel {
        private Map<String, ToolTipModel> entries = new LinkedHashMap<String, ToolTipModel>();

        public ToolTipModel getEntry(String itemText) {
            return this.entries.get(itemText);
        }

        public void addEntry(String itemText, String tooltipText) {
            ToolTipModel model = new ToolTipModel(null, itemText, null, tooltipText);
            this.entries.put(itemText, model);
        }

        public void addEntry(String buttonIcon, String buttonText, String toolTipIcon, String toolTipText) {
            ToolTipModel model = new ToolTipModel(buttonIcon, buttonText, toolTipIcon, toolTipText);
            this.entries.put(buttonText, model);
        }

        public void clear() {
            this.entries.clear();
        }

        public TextButtonTabs.TextButtonTabModel toTextButtonTabModel() {
            TextButtonTabs.TextButtonTabModel model = null;
            return model;
        }
    }

    public static class ToolTipModel {
        public String toolTipIcon;
        public String toolTipText;
        public String buttonIcon;
        public String buttonText;

        public ToolTipModel(String buttonIcon, String buttonText, String toolTipIcon, String toolTipText) {
            this.toolTipIcon = toolTipIcon;
            this.toolTipText = toolTipText;
            this.buttonIcon = buttonIcon;
            this.buttonText = buttonText;
        }
    }
}

