/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;

public class MessageBox
extends AstraXComponent {
    private Label messageLabel;
    private Image icon;
    private AstraXTextButton okButton;

    public MessageBox(ComponentFactory componentFactory) {
        super(componentFactory, "window-body");
        if (this.background != null) {
            this.pad(this.background.getStyle().padding);
        }
        this.messageLabel = new Label("", componentFactory.getSkin(), "default-no-bg");
        this.messageLabel.setAlignment(1, 1);
        this.okButton = new AstraXTextButton(componentFactory, "primary");
        this.okButton.setText("OK");
        this.okButton.setCanCheck(false);
        this.okButton.addListener(componentFactory.getButtonSoundListener("default"));
        this.okButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                MessageBox.this.fire(changeEvent);
                Pools.free(changeEvent);
            }
        });
    }

    public void setIcon(String iconName) {
        if (iconName != null && this.icon == null) {
            this.icon = new Image(this.getSkin().getDrawable(iconName));
        } else if (this.icon != null) {
            this.icon.setVisible(false);
        }
    }

    public void setText(String text) {
        this.messageLabel.setText(text);
        this.pack();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        if (this.icon != null && this.icon.isVisible()) {
            this.add(this.icon).pad(20.0f).top();
            this.add(this.messageLabel).padTop(20.0f).padRight(20.0f).padBottom(10.0f).top();
            this.row();
            this.add();
            this.add(this.okButton).minWidth(140.0f).right();
        } else {
            this.add(this.messageLabel).pad(20.0f).fill();
            this.row();
            this.add(this.okButton).minWidth(140.0f).right();
        }
        this.pack();
    }

    public static class MessageBoxStyle {
    }
}

