/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.DefaultPaginator;
import com.neutronio.astrax.util.DateFormats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageLog
extends SimplePanel {
    private boolean showTimestamps = false;
    private int entriesPerPage = 5;
    private ComponentFactory componentFactory;
    private Message.MessageComparator messageComparator = new Message.MessageComparator();
    private List<Message> messages = new ArrayList<Message>();
    private List<Label> labels = new ArrayList<Label>();
    private List<Label> timestamps = new ArrayList<Label>();
    private DefaultPaginator paginator;

    public MessageLog(ComponentFactory componentFactory, String backgroundStyle, int entriesPerPage) {
        super(componentFactory, "default", backgroundStyle);
        this.componentFactory = componentFactory;
        this.paginator = new DefaultPaginator();
        this.align(8);
        this.setEntriesPerPage(entriesPerPage);
    }

    public boolean isShowTimestamps() {
        return this.showTimestamps;
    }

    public void setShowTimestamps(boolean showTimestamps) {
        this.showTimestamps = showTimestamps;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public int getEntriesPerPage() {
        return this.entriesPerPage;
    }

    public DefaultPaginator getPaginator() {
        return this.paginator;
    }

    public void setEntriesPerPage(int entriesPerPage) {
        this.entriesPerPage = entriesPerPage;
    }

    @Override
    public void construct() {
        for (int i2 = 0; i2 < this.entriesPerPage; ++i2) {
            if (this.showTimestamps) {
                Label timestamp = new Label("", this.componentFactory.getSkin(), "default-no-bg");
                timestamp.setAlignment(8, 8);
                this.timestamps.add(timestamp);
                this.add(timestamp).left().fill().padBottom(5.0f).padRight(5.0f);
            }
            Label entry = new Label("", this.componentFactory.getSkin(), "default-no-bg");
            entry.setAlignment(8, 8);
            this.labels.add(entry);
            this.add(entry).left().fill().padBottom(5.0f);
            this.row();
        }
        this.pack();
    }

    public void clearMessages() {
        this.messages.clear();
        this.paginator.setMaxPages(1);
    }

    public void addMessages(List<Message> messages) {
        this.messages.addAll(messages);
        int maxPageCount = this.entriesPerPage > 0 ? (int)Math.ceil((float)this.messages.size() / (float)this.entriesPerPage) : 1;
        this.paginator.setMaxPages(maxPageCount);
    }

    public void addMessage(Message message) {
        if (message == null) {
            return;
        }
        this.messages.add(message);
        int maxPageCount = this.entriesPerPage > 0 ? (int)Math.ceil((float)this.messages.size() / (float)this.entriesPerPage) : 1;
        this.paginator.setMaxPages(maxPageCount);
    }

    public void sortMessages() {
        if (!this.showTimestamps) {
            Collections.sort(this.messages, this.messageComparator);
        }
    }

    public void update() {
        int startIndex = (this.paginator.getCurrentPage() - 1) * this.entriesPerPage;
        int labelIndex = 0;
        int i2 = 0;
        for (Label label : this.labels) {
            label.setText("");
            label.setStyle(this.componentFactory.getSkin().get("label-transparent", Label.LabelStyle.class));
            if (this.showTimestamps) {
                this.timestamps.get(i2).setText("");
            }
            ++i2;
        }
        for (int k = startIndex; k < startIndex + this.messages.size() && k < this.messages.size() && labelIndex < this.labels.size(); ++labelIndex, ++k) {
            Message message = this.messages.get(k);
            this.labels.get(labelIndex).setText(message.getMessage());
            this.labels.get(labelIndex).setStyle(this.componentFactory.getSkin().get(message.getType().toLabelStyle(), Label.LabelStyle.class));
            if (!this.showTimestamps) continue;
            this.timestamps.get(k).setText(DateFormats.HOUR_MINUTE.format(message.getTimestamp()));
        }
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isVisible()) {
            this.update();
        }
    }
}

