/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.Header;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.logging.Logger;

public class Modal<C extends Actor>
extends Group {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected C component;
    protected Table content;
    protected Image background;
    protected Header header;

    public Modal(ComponentFactory componentFactory, C actor) {
        this.component = actor;
        this.background = new Image();
        this.background.setDrawable(componentFactory.getSkin().getDrawable("icon_bg_rhombus_t50_n"));
        this.background.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.background.setVisible(false);
        this.background.setTouchable(Touchable.disabled);
        this.header = new Header(componentFactory);
        this.header.construct();
        this.header.getExitButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!Modal.this.header.getExitButton().isDisabled()) {
                    Modal.this.hide();
                }
            }
        });
        this.content = new Table();
        this.content.add(this.header).colspan(2).fill();
        this.content.row();
        this.content.add(this.component).colspan(2).minWidth(300.0f);
        this.content.pack();
        this.content.setVisible(false);
        this.addActor(this.background);
        this.addActor(this.content);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                Modal.this.logger.finest("Actor target: " + event.getTarget().getClass() + ", bubbles: " + event.getBubbles() + ", content visible: " + Modal.this.content.isVisible() + ", background touchable: " + (Object)((Object)Modal.this.background.getTouchable()));
                if (!event.getBubbles()) {
                    return;
                }
                if (!Modal.this.content.isVisible() && Modal.this.background.isVisible()) {
                    Modal.this.logger.warning("Modal bugging out!");
                    Modal.this.hide();
                }
                Modal.this.getStage().setKeyboardFocus(event.getListenerActor());
            }
        });
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (Modal.this.content.isVisible() && keycode == 111 && !Modal.this.header.exitButton.isDisabled()) {
                    Modal.this.logger.finest("ESC was pressed!");
                    Modal.this.hide();
                    return true;
                }
                return false;
            }
        });
    }

    public void pack() {
        this.content.pack();
    }

    public Table getContent() {
        return this.content;
    }

    public void setExitButtonDisabled(boolean disabled) {
        this.header.exitButton.setDisabled(disabled);
    }

    public void setHeaderIcon(String inlineIcon) {
        this.header.setHeaderIcon(inlineIcon);
    }

    public void setHeaderText(String text) {
        this.header.setTitle(text);
    }

    public void hide() {
        this.logger.finest("Hide modal");
        this.background.addAction(Tweening.getDefaultFadeOut(0.2f));
        this.content.addAction(Tweening.getCenteredFadeOut());
    }

    public void show() {
        this.logger.finest("Show modal");
        this.background.addAction(Tweening.getDefaultFadeIn(0.2f));
        this.content.addAction(Tweening.getCenteredFadeIn());
    }
}

