/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.widgets.Paginator;

public class PaginatorComponent
extends AstraXComponent {
    private Paginator paginator;
    private AstraXButton previousButton;
    private AstraXButton nextButton;
    private Label displayedText;

    public PaginatorComponent(ComponentFactory componentFactory) {
        super(componentFactory);
        this.previousButton = new AstraXButton(componentFactory, "icon_inline_arrow_left", "primary-no-check");
        this.previousButton.setCanCheck(false);
        this.nextButton = new AstraXButton(componentFactory, "icon_inline_arrow_right", "primary-no-check");
        this.nextButton.setCanCheck(false);
        this.displayedText = new Label("0", componentFactory.getSkin(), "default-no-bg");
        this.displayedText.setAlignment(1, 1);
        this.previousButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                PaginatorComponent.this.previous();
            }
        });
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                PaginatorComponent.this.next();
            }
        });
        this.add(this.previousButton).size(this.previousButton.getStyle().width, this.previousButton.getStyle().height).padRight(10.0f).right().align(16);
        this.add(this.displayedText).minWidth(200.0f);
        this.add(this.nextButton).size(this.previousButton.getStyle().width, this.previousButton.getStyle().height).padLeft(10.0f).left();
    }

    public void setPaginator(Paginator paginator) {
        this.paginator = paginator;
        this.update();
    }

    public int getMaxPages() {
        return this.paginator.getMaxPages();
    }

    public void next() {
        this.paginator.nextPage();
        this.update();
        this.fire(new ChangeListener.ChangeEvent());
    }

    public void previous() {
        this.paginator.previousPage();
        this.update();
        this.fire(new ChangeListener.ChangeEvent());
    }

    public void update() {
        this.displayedText.setText(this.paginator.getCurrentPage() + "/" + this.paginator.getMaxPages());
    }
}

