/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;

public class PlayerControlWidget
extends HorizontalGroup {
    AstraXButton playButton;
    AstraXButton stopButton;
    AstraXButton pauseButton;
    AstraXButton nextButton;
    AstraXButton previousButton;
    ButtonGroup<AstraXButton> buttonGroup;
    UserPlayerListener listener;

    public PlayerControlWidget(ComponentFactory componentFactory) {
        this.space(5.0f);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.setMinCheckCount(0);
        this.buttonGroup.setMaxCheckCount(1);
        this.buttonGroup.setUncheckLast(true);
        this.playButton = new AstraXButton(componentFactory, "icon_inline_play", "primary-no-check");
        this.playButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (PlayerControlWidget.this.getListener() != null) {
                    PlayerControlWidget.this.getListener().onPlay();
                }
            }
        });
        this.stopButton = new AstraXButton(componentFactory, "icon_inline_stop", "primary-no-check");
        this.stopButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (PlayerControlWidget.this.getListener() != null) {
                    PlayerControlWidget.this.getListener().onStop();
                }
            }
        });
        this.pauseButton = new AstraXButton(componentFactory, "icon_inline_pause", "primary-no-check");
        this.pauseButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (PlayerControlWidget.this.getListener() != null) {
                    PlayerControlWidget.this.getListener().onPause();
                }
            }
        });
        this.nextButton = new AstraXButton(componentFactory, "icon_inline_next", "primary-no-check");
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (PlayerControlWidget.this.getListener() != null) {
                    PlayerControlWidget.this.getListener().onNext();
                }
            }
        });
        this.previousButton = new AstraXButton(componentFactory, "icon_inline_previous", "primary-no-check");
        this.previousButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (PlayerControlWidget.this.getListener() != null) {
                    PlayerControlWidget.this.getListener().onPrevious();
                }
            }
        });
        this.buttonGroup.add((AstraXButton)new AstraXButton[]{this.playButton, this.stopButton, this.pauseButton, this.nextButton, this.previousButton});
        this.addActor(this.previousButton);
        this.addActor(this.playButton);
        this.addActor(this.pauseButton);
        this.addActor(this.stopButton);
        this.addActor(this.nextButton);
    }

    public UserPlayerListener getListener() {
        return this.listener;
    }

    public void setListener(UserPlayerListener listener) {
        this.listener = listener;
    }

    public static interface UserPlayerListener {
        public void onPlay();

        public void onStop();

        public void onPause();

        public void onNext();

        public void onPrevious();
    }
}

