/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.util.AstraXUtil;

public class RGBSlider
extends AbstractForm {
    public static String HEX_HINT = "Copy & Paste hex codes from different programs here";
    private Slider redValue;
    private Slider blueValue;
    private Slider greenValue;
    private TextField hexValue;
    private Image preview;
    private String hexRegex = "#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]";

    public RGBSlider(ComponentFactory componentFactory) {
        super(componentFactory, "colorpicker");
        this.hexValue = new TextField("", componentFactory.getSkin());
        this.hexValue.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (RGBSlider.this.hexValue.getText().length() > 0) {
                    RGBSlider.this.updateColorFromHex();
                }
            }
        });
        this.hexValue.addListener(new Tooltip<Label>(new Label(this.getTranslation("color_hex_hint"), componentFactory.getSkin(), "tooltip")));
        ChangeListener sliderUpdater = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                RGBSlider.this.updateColorFromSliders();
            }
        };
        this.redValue = new Slider(0.0f, 1.0f, 0.003921569f, false, componentFactory.getSkin());
        this.redValue.addListener(sliderUpdater);
        this.blueValue = new Slider(0.0f, 1.0f, 0.003921569f, false, componentFactory.getSkin());
        this.blueValue.addListener(sliderUpdater);
        this.greenValue = new Slider(0.0f, 1.0f, 0.003921569f, false, componentFactory.getSkin());
        this.greenValue.addListener(sliderUpdater);
        this.preview = new Image(this.getSkin().getPatch("background_para"));
        this.preview.setSize(48.0f, 48.0f);
        this.add(this.preview).minSize(32.0f, 32.0f).fill().colspan(2).padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.row();
        this.addRow(this.getTranslation("color_red"), this.redValue);
        this.row();
        this.addRow(this.getTranslation("color_green"), this.greenValue);
        this.row();
        this.addRow(this.getTranslation("color_blue"), this.blueValue);
        this.row();
        this.addLabel(this.getTranslation("color_hex"));
        this.addValue(this.hexValue, 1);
        this.updateColorFromSliders();
    }

    private void updateColorFromSliders() {
        Color color = new Color(this.redValue.getValue(), this.greenValue.getValue(), this.blueValue.getValue(), 1.0f);
        this.preview.setColor(color);
        this.hexValue.setText("#" + AstraXUtil.colorToHexString(color));
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    private void updateColorFromHex() {
        if (this.hexValue.getText().matches(this.hexRegex)) {
            String hex = this.hexValue.getText().replace('#', ' ').trim();
            Color color = Color.valueOf(hex);
            this.setPickedColor(color);
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            this.fire(changeEvent);
            Pools.free(changeEvent);
        }
    }

    public void setPickedColor(Color color) {
        this.redValue.setValue(color.r);
        this.greenValue.setValue(color.g);
        this.blueValue.setValue(color.b);
        this.updateColorFromSliders();
    }

    public Color getPickedColor() {
        return this.preview.getColor();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        return result;
    }

    @Override
    public void resetForm() {
    }

    @Override
    public void resetValues() {
    }
}

