/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import java.util.ArrayList;
import java.util.List;

public class RatingComponent
extends HorizontalGroup {
    private RatingComponentStyle style;
    private List<Image> images = new ArrayList<Image>();
    private boolean editable = false;

    public RatingComponent(Skin skin, String style, int size) {
        this.style = skin.get(style, RatingComponentStyle.class);
        this.pad(3.0f);
        this.space(5.0f);
        for (int i2 = 0; i2 < size; ++i2) {
            Image image = new Image(this.style.empty);
            this.addActor(image);
            this.images.add(image);
        }
        this.pack();
    }

    public RatingComponent(Skin skin, int size) {
        this(skin, "default", size);
    }

    public void setRating(int rating) {
        for (int i2 = 0; i2 < this.images.size(); ++i2) {
            Image image = this.images.get(i2);
            if (i2 < rating) {
                image.setDrawable(this.style.up);
                continue;
            }
            image.setDrawable(this.style.empty);
        }
    }

    public static class RatingComponentStyle {
        Drawable up;
        Drawable empty;
    }
}

