/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.app.repository.GenericRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.ListComponent;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import java.util.ArrayList;
import java.util.List;

public class RepositoryCRUDComponent<R extends GenericRepository<W>, W>
extends SimplePanel {
    private R repository;
    private AstraXButton saveButton;
    private AstraXButton loadButton;
    private AstraXButton editButton;
    private AstraXButton addButton;
    private AstraXButton deleteButton;
    private ListComponent<W> list;
    private RepositoryProducer<W> producer;

    public RepositoryCRUDComponent(ComponentFactory componentFactory) {
        super(componentFactory);
        this.saveButton = new AstraXButton(componentFactory, "icon_inline_save", "primary-no-check");
        this.saveButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                RepositoryCRUDComponent.this.producer.saveAs();
            }
        });
        this.saveButton.addListener(componentFactory.getToolTip("Saves the whole repository."));
        this.loadButton = new AstraXButton(componentFactory, "icon_inline_folder", "primary-no-check");
        this.loadButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
            }
        });
        this.loadButton.addListener(componentFactory.getToolTip("Loads a whole repository."));
        this.addButton = new AstraXButton(componentFactory, "icon_inline_plus", "control-green");
        this.addButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                RepositoryCRUDComponent.this.repository.add("new", RepositoryCRUDComponent.this.producer.create());
                RepositoryCRUDComponent.this.updateEntries();
            }
        });
        this.addButton.addListener(componentFactory.getToolTip("Adds an item to the repository."));
        this.editButton = new AstraXButton(componentFactory, "icon_inline_edit", "primary-no-check");
        this.editButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                RepositoryCRUDComponent.this.producer.onEdit(RepositoryCRUDComponent.this.list.getSelectedElement());
            }
        });
        this.editButton.addListener(componentFactory.getToolTip("Edits the selected item."));
        this.deleteButton = new AstraXButton(componentFactory, "icon_inline_trash", "control-red");
        this.deleteButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (RepositoryCRUDComponent.this.getSelected() != null) {
                    RepositoryCRUDComponent.this.repository.remove(RepositoryCRUDComponent.this.getSelected().toString());
                    RepositoryCRUDComponent.this.updateEntries();
                }
            }
        });
        this.deleteButton.addListener(componentFactory.getToolTip("Deletes the selected item."));
        this.list = new ListComponent(componentFactory);
        HorizontalGroup topButtonGroup = new HorizontalGroup();
        topButtonGroup.space(10.0f);
        topButtonGroup.addActor(this.saveButton);
        topButtonGroup.addActor(this.loadButton);
        HorizontalGroup bottomButtonGroup = new HorizontalGroup();
        bottomButtonGroup.space(10.0f);
        bottomButtonGroup.addActor(this.editButton);
        bottomButtonGroup.addActor(this.addButton);
        bottomButtonGroup.addActor(this.deleteButton);
        this.addValue(topButtonGroup, 1);
        this.row();
        this.addValue(this.list, 1);
        this.row();
        this.addValue(bottomButtonGroup, 1);
        this.pack();
    }

    public W getSelected() {
        return this.list.getSelectedElement();
    }

    public void setRepository(R repository) {
        this.repository = repository;
        this.updateEntries();
    }

    public void setProducer(RepositoryProducer<W> producer) {
        this.producer = producer;
    }

    private void updateEntries() {
        List objects = ((GenericRepository)this.repository).all();
        ArrayList wrappers = new ArrayList();
        for (Object object : objects) {
            wrappers.add(new SelectBoxWrapper(object.toString(), object));
        }
        this.list.setElements(wrappers);
        this.pack();
    }

    public static interface RepositoryProducer<W> {
        public W create();

        public void saveAs();

        public void onEdit(W var1);
    }
}

