/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.neutronio.astrax.ui.commons.widgets.Zoomer;

public class ScrollContainer<C extends Actor>
extends Container<C> {
    protected Zoomer zoomer;
    protected DragListener dragListener;
    private float zoomStrength = 2.1f;

    public ScrollContainer(C component) {
        super(component);
        this.setClip(true);
        this.zoomer = new Zoomer(1.0f, 0.1f, 3.0f);
        this.dragListener = new DragListener(){

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                super.drag(event, x, y, pointer);
                ((Actor)ScrollContainer.this.getActor()).addAction(Actions.moveTo(((Actor)ScrollContainer.this.getActor()).getX() + this.getDeltaX() * 0.7f, ((Actor)ScrollContainer.this.getActor()).getY() + this.getDeltaY() * 0.7f));
            }
        };
        this.addListener(this.dragListener);
        this.addListener(new ClickListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                ScrollContainer.this.zoomer.zoom(-ScrollContainer.this.getZoomStrength() * Math.signum(amountY));
                return super.scrolled(event, x, y, amountX, amountY);
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                ScrollContainer.this.getStage().setScrollFocus((Actor)ScrollContainer.this.getActor());
            }
        });
        ((Actor)this.getActor()).setOrigin(1);
        this.pack();
    }

    public void setZoomStrength(float zoomStrength) {
        this.zoomStrength = zoomStrength;
    }

    public float getZoomStrength() {
        return this.zoomStrength;
    }

    public Zoomer getZoomer() {
        return this.zoomer;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.zoomer.update(Gdx.graphics.getDeltaTime());
        ((Actor)this.getActor()).setScale(this.zoomer.getCurrentZoom(), this.zoomer.getCurrentZoom());
        super.draw(batch, parentAlpha);
    }
}

